/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.http.HttpResponse;
import com.paypal.payments.Authorization;
import com.paypal.payments.AuthorizationsGetRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalAuthorizationRetrievalResponse;

public class PayPalAuthorizationRetrievalRequest
extends AbstractPayPalRequest<Authorization, AuthorizationsGetRequest> {
    private final String authId;

    public PayPalAuthorizationRetrievalRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest, String authId) {
        super(clientProvider, paymentRequest);
        this.authId = authId;
    }

    @Override
    protected AuthorizationsGetRequest buildRequest() {
        return new AuthorizationsGetRequest(this.getAuthId());
    }

    @Override
    protected AbstractPayPalResponse<Authorization> executeInternal() throws IOException {
        HttpResponse response = this.getClient().execute(this.getRequest());
        return new PayPalAuthorizationRetrievalResponse((HttpResponse<Authorization>)response);
    }

    @Override
    protected boolean isValidInternal() {
        return StringUtils.isNotBlank((CharSequence)this.getAuthId());
    }

    protected String getAuthId() {
        return this.authId;
    }
}

