/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.core.PayPalHttpClient;
import com.paypal.http.HttpRequest;
import java.io.IOException;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.exception.PayPalInvalidRequestStateException;
import org.broadleafcommerce.vendor.paypal.service.exception.PayPalRESTException;
import org.broadleafcommerce.vendor.paypal.service.payment.AbstractPayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponse;

public abstract class AbstractPayPalRequest<RES, REQ extends HttpRequest<RES>>
implements PayPalRequest {
    private final PayPalClientProvider clientProvider;
    private final PaymentRequestDTO paymentRequest;
    private REQ request;
    private boolean executed = false;

    public AbstractPayPalRequest(PayPalClientProvider clientProvider, PaymentRequestDTO paymentRequest) {
        this.clientProvider = clientProvider;
        this.paymentRequest = paymentRequest;
    }

    @Override
    public PayPalResponse execute() {
        if (this.request == null) {
            this.configureRequest(this.paymentRequest);
        }
        if (this.isValid()) {
            this.setExecuted(true);
            try {
                return this.executeInternal();
            }
            catch (IOException e) {
                throw new PayPalRESTException(e);
            }
        }
        throw new PayPalInvalidRequestStateException("Request state is invalid");
    }

    protected boolean isValid() {
        return this.isValidInternal() && !this.executed;
    }

    protected void configureRequest(PaymentRequestDTO paymentRequest) {
        this.request = this.buildRequest();
        this.getClientProvider().configureRequest((HttpRequest<?>)this.request, paymentRequest);
    }

    protected PayPalHttpClient getClient() {
        return this.getClientProvider().getClient();
    }

    protected abstract REQ buildRequest();

    protected abstract AbstractPayPalResponse<RES> executeInternal() throws IOException;

    protected abstract boolean isValidInternal();

    protected PayPalClientProvider getClientProvider() {
        return this.clientProvider;
    }

    protected PaymentRequestDTO getPaymentRequest() {
        return this.paymentRequest;
    }

    protected REQ getRequest() {
        return this.request;
    }

    protected boolean isExecuted() {
        return this.executed;
    }

    private void setExecuted(boolean executed) {
        this.executed = executed;
    }
}

