/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service;

import com.paypal.orders.AddressPortable;
import com.paypal.orders.AmountBreakdown;
import com.paypal.orders.AmountWithBreakdown;
import com.paypal.orders.ApplicationContext;
import com.paypal.orders.Item;
import com.paypal.orders.Money;
import com.paypal.orders.Name;
import com.paypal.orders.Order;
import com.paypal.orders.OrderRequest;
import com.paypal.orders.Patch;
import com.paypal.orders.Payee;
import com.paypal.orders.Payer;
import com.paypal.orders.PurchaseUnitRequest;
import com.paypal.orders.ShippingDetail;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.payment.dto.AddressDTO;
import org.broadleafcommerce.common.payment.dto.GatewayCustomerDTO;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.service.CurrentOrderPaymentRequestService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.PayPalPaymentService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreateOrderRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreateOrderResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalUpdateOrderRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalUpdateOrderResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="blPayPalPaymentService")
public class PayPalPaymentServiceImpl
implements PayPalPaymentService {
    protected static final String REPLACE_OP_TYPE = "replace";
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService externalCallService;
    @Autowired(required=false)
    protected CurrentOrderPaymentRequestService currentOrderPaymentRequestService;
    @Resource(name="blPayPalClientProvider")
    protected PayPalClientProvider clientProvider;
    @Value(value="${gateway.paypal.checkout.rest.populate.shipping.create.order:true}")
    protected boolean shouldPopulateShippingOnOrderCreation;

    @Override
    public Order createPayPalOrderForCurrentOrder(boolean performCheckoutOnReturn) throws PaymentException {
        PaymentRequestDTO paymentRequest = this.getPaymentRequestForCurrentOrder();
        PurchaseUnitRequest purchaseUnitRequest = new PurchaseUnitRequest().amountWithBreakdown(this.constructAmountWithBreakdown(paymentRequest)).payee(this.constructPayee(paymentRequest)).description(this.externalCallService.getConfiguration().getPaymentDescription()).customId(String.format("%s|%s", paymentRequest.getOrderId(), performCheckoutOnReturn));
        purchaseUnitRequest.items(this.constructItems(paymentRequest));
        if (this.shouldPopulateShippingOnOrderCreation) {
            purchaseUnitRequest.shippingDetail(this.constructShippingDetail(paymentRequest));
        }
        String shippingPreference = (String)paymentRequest.getAdditionalFields().get("SHIPPING_PREFERENCE");
        String locale = Optional.ofNullable((Locale)paymentRequest.getAdditionalFields().get("LOCALE")).map(Locale::toLanguageTag).map(loc -> loc.replace("_", "-")).orElse(null);
        OrderRequest order = new OrderRequest().checkoutPaymentIntent(this.getIntent(performCheckoutOnReturn)).payer(this.constructPayer(paymentRequest)).purchaseUnits(Collections.singletonList(purchaseUnitRequest)).applicationContext(new ApplicationContext().shippingPreference(shippingPreference).locale(locale));
        return this.createOrder(order, paymentRequest);
    }

    @Override
    public void updatePayPalOrderForFulfillment() throws PaymentException {
        PaymentRequestDTO paymentRequest = this.getPaymentRequestForCurrentOrder();
        String orderId = this.getPayPalOrderIdFromCurrentOrder();
        if (StringUtils.isBlank((CharSequence)orderId)) {
            throw new PaymentException("Unable to update the current PayPal payment because no PayPal payment id was found on the order");
        }
        PurchaseUnitRequest purchaseUnitRequest = new PurchaseUnitRequest().amountWithBreakdown(this.constructAmountWithBreakdown(paymentRequest)).payee(this.constructPayee(paymentRequest)).description(this.externalCallService.getConfiguration().getPaymentDescription()).customId(paymentRequest.getOrderId() + "|true");
        purchaseUnitRequest.items(this.constructItems(paymentRequest));
        if (this.shouldPopulateShippingOnOrderCreation) {
            purchaseUnitRequest.shippingDetail(this.constructShippingDetail(paymentRequest));
        }
        Patch amountPatch = new Patch().op(REPLACE_OP_TYPE).path("/purchase_units/@reference_id=='default'").value((Object)purchaseUnitRequest);
        this.updateOrder(orderId, Collections.singletonList(amountPatch), paymentRequest);
    }

    protected Order createOrder(OrderRequest orderRequest, PaymentRequestDTO paymentRequest) throws PaymentException {
        PayPalCreateOrderRequest request = new PayPalCreateOrderRequest(this.clientProvider, paymentRequest, orderRequest);
        PayPalCreateOrderResponse response = this.externalCallService.call(request, PayPalCreateOrderResponse.class);
        return (Order)response.getContent();
    }

    protected void updateOrder(String orderId, List<Patch> patches, PaymentRequestDTO paymentRequest) throws PaymentException {
        Assert.hasText((String)orderId, (String)"OrderId cannot be blank");
        Assert.notEmpty(patches, (String)"Patches cannot be empty");
        PayPalUpdateOrderRequest request = new PayPalUpdateOrderRequest(this.clientProvider, paymentRequest, orderId, patches);
        this.externalCallService.call(request, PayPalUpdateOrderResponse.class);
    }

    protected Payee constructPayee(PaymentRequestDTO paymentRequest) {
        String merchantId = (String)paymentRequest.getAdditionalFields().get("PAYEE_MERCHANT_ID");
        if (StringUtils.isBlank((CharSequence)merchantId)) {
            return null;
        }
        String merchantEmail = (String)paymentRequest.getAdditionalFields().get("PAYEE_MERCHANT_EMAIL");
        return new Payee().merchantId(merchantId).email(merchantEmail);
    }

    protected Payer constructPayer(PaymentRequestDTO paymentRequestDTO) {
        return new Payer().email(this.getPayerEmail(paymentRequestDTO));
    }

    protected String getPayerEmail(PaymentRequestDTO paymentRequestDTO) {
        return Optional.ofNullable(paymentRequestDTO.getCustomer()).map(GatewayCustomerDTO::getEmail).orElse(null);
    }

    protected List<Item> constructItems(PaymentRequestDTO paymentRequest) {
        if (!CollectionUtils.isNotEmpty((Collection)paymentRequest.getLineItems())) {
            return Collections.emptyList();
        }
        return paymentRequest.getLineItems().stream().map(lineItem -> new Item().category(lineItem.getCategory()).description(lineItem.getDescription()).name(lineItem.getName()).quantity(Objects.toString(lineItem.getQuantity(), null)).sku(lineItem.getSystemId()).tax(this.convertToMoney(lineItem.getTax(), paymentRequest.getOrderCurrencyCode())).unitAmount(this.convertToMoney(lineItem.getAmount(), paymentRequest.getOrderCurrencyCode()))).collect(Collectors.toList());
    }

    protected ShippingDetail constructShippingDetail(PaymentRequestDTO paymentRequest) {
        AddressDTO address = paymentRequest.getShipTo();
        if (address == null) {
            return null;
        }
        return new ShippingDetail().name(new Name().fullName(address.getAddressFullName())).addressPortable(new AddressPortable().addressLine1(address.getAddressLine1()).addressLine2(address.getAddressLine2()).adminArea2(address.getAddressCityLocality()).adminArea1(address.getAddressStateRegion()).postalCode(address.getAddressPostalCode()).countryCode(address.getAddressCountryCode()));
    }

    protected AmountWithBreakdown constructAmountWithBreakdown(PaymentRequestDTO paymentRequest) {
        AmountBreakdown details = new AmountBreakdown().itemTotal(this.convertToMoney(paymentRequest.getOrderSubtotal(), paymentRequest.getOrderCurrencyCode())).shipping(this.convertToMoney(paymentRequest.getShippingTotal(), paymentRequest.getOrderCurrencyCode())).taxTotal(this.convertToMoney(paymentRequest.getTaxTotal(), paymentRequest.getOrderCurrencyCode()));
        return new AmountWithBreakdown().currencyCode(paymentRequest.getOrderCurrencyCode()).value(paymentRequest.getTransactionTotal()).amountBreakdown(details);
    }

    protected Money convertToMoney(String value, String currencyCode) {
        return new Money().value(value).currencyCode(currencyCode);
    }

    @Override
    public PaymentRequestDTO getPaymentRequestForCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.getPaymentRequestFromCurrentOrder();
        }
        throw new PaymentException("Unable to get PaymentRequestDTO for current order");
    }

    @Override
    public String getPayPalOrderIdFromCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.retrieveOrderAttributeFromCurrentOrder("ORDER_ID");
        }
        throw new PaymentException("Unable to retrieve PayPal payment id for current order");
    }

    @Override
    public String getPayPalPayerIdFromCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.retrieveOrderAttributeFromCurrentOrder("PAYERID");
        }
        throw new PaymentException("Unable to retrieve PayPal payer id for current order");
    }

    @Override
    public void setPayPalOrderIdOnCurrentOrder(String orderId) throws PaymentException {
        if (this.currentOrderPaymentRequestService == null) {
            throw new PaymentException("Unable to set PayPal payment id on current order");
        }
        this.currentOrderPaymentRequestService.addOrderAttributeToCurrentOrder("ORDER_ID", orderId);
    }

    @Override
    public void setPayPalPayerIdOnCurrentOrder(String payerId) throws PaymentException {
        if (this.currentOrderPaymentRequestService == null) {
            throw new PaymentException("Unable to set PayPal payer id on current order");
        }
        this.currentOrderPaymentRequestService.addOrderAttributeToCurrentOrder("PAYERID", payerId);
    }

    public String getIntent(boolean performCheckoutOnReturn) {
        if (this.externalCallService.getConfiguration().isPerformAuthorizeAndCapture()) {
            return "CAPTURE";
        }
        return "AUTHORIZE";
    }
}

