/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service;

import com.paypal.core.PayPalEnvironment;
import com.paypal.core.PayPalHttpClient;
import com.paypal.http.HttpRequest;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.Map;
import java.util.UUID;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.payment.service.gateway.PayPalCheckoutConfiguration;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalCheckoutEnvironmentType;
import org.springframework.stereotype.Service;

@Service(value="blPayPalClientProvider")
public class PayPalClientProviderImpl
implements PayPalClientProvider {
    private PayPalHttpClient client;
    @Resource(name="blPayPalCheckoutConfiguration")
    protected PayPalCheckoutConfiguration configuration;

    @PostConstruct
    public void init() {
        this.client = this.configureClient(this.configuration);
    }

    private PayPalHttpClient configureClient(PayPalCheckoutConfiguration configuration) {
        Object environment = PayPalCheckoutEnvironmentType.SANDBOX.type().equals(configuration.getEnvironment()) ? new PayPalEnvironment.Sandbox(configuration.getClientId(), configuration.getClientSecret()) : new PayPalEnvironment.Live(configuration.getClientId(), configuration.getClientSecret());
        return new PayPalHttpClient((PayPalEnvironment)environment);
    }

    @Override
    public void configureRequest(HttpRequest<?> request, PaymentRequestDTO paymentRequest) {
        request.header("PayPal-Partner-Attribution-Id", "BroadleafCommerce_Cart_EC");
        request.header("PayPal-Request-Id", this.buildIdempotencyKey(paymentRequest));
        Map additionalFields = paymentRequest.getAdditionalFields();
        if (additionalFields.containsKey("PayPal-Auth-Assertion")) {
            request.header("PayPal-Auth-Assertion", (String)additionalFields.get("PayPal-Auth-Assertion"));
        }
        if (additionalFields.containsKey("PayPal-Client-Metadata-Id")) {
            request.header("PayPal-Client-Metadata-Id", (String)additionalFields.get("PayPal-Client-Metadata-Id"));
        }
        if (additionalFields.containsKey("PayPal-Mock-Response")) {
            request.header("PayPal-Mock-Response", (String)additionalFields.get("PayPal-Mock-Response"));
        }
    }

    protected String buildIdempotencyKey(PaymentRequestDTO paymentRequest) {
        Map additionalFields = paymentRequest.getAdditionalFields();
        if (additionalFields.containsKey("idempotency_key")) {
            return (String)additionalFields.get("idempotency_key");
        }
        return UUID.randomUUID().toString();
    }

    @Override
    public PayPalHttpClient getClient() {
        return this.client;
    }
}

