/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayWebResponseService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayReportingService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponsePrintService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponseService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.PayPalPaymentService;
import org.springframework.stereotype.Service;

@Service(value="blPayPalCheckoutWebResponseService")
public class PayPalCheckoutWebResponseServiceImpl
extends AbstractPaymentGatewayWebResponseService
implements PaymentGatewayWebResponseService {
    private static final Log LOG = LogFactory.getLog(PayPalCheckoutWebResponseServiceImpl.class);
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService externalCallService;
    @Resource(name="blPaymentGatewayWebResponsePrintService")
    protected PaymentGatewayWebResponsePrintService webResponsePrintService;
    @Resource(name="blPayPalCheckoutReportingService")
    protected PaymentGatewayReportingService reportingService;
    @Resource(name="blPayPalPaymentService")
    protected PayPalPaymentService paymentService;

    public PaymentResponseDTO translateWebResponse(HttpServletRequest request) throws PaymentException {
        String orderId = request.getParameter("orderId");
        String payerId = request.getParameter("payerId");
        PaymentRequestDTO requestDTO = this.paymentService.getPaymentRequestForCurrentOrder();
        requestDTO.additionalField("orderId", (Object)orderId).additionalField("payerId", (Object)payerId);
        PaymentResponseDTO responseDTO = this.reportingService.findDetailsByTransaction(requestDTO);
        responseDTO.responseMap("HTTP_REQUEST", this.webResponsePrintService.printRequest(request)).paymentTransactionType(PaymentTransactionType.UNCONFIRMED);
        this.paymentService.setPayPalOrderIdOnCurrentOrder(orderId);
        this.paymentService.setPayPalPayerIdOnCurrentOrder(payerId);
        return responseDTO;
    }
}

