/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import com.paypal.http.HttpResponse;
import com.paypal.http.exceptions.HttpException;
import com.paypal.orders.AmountWithBreakdown;
import com.paypal.orders.Order;
import com.paypal.orders.PaymentCollection;
import com.paypal.orders.PurchaseUnit;
import com.paypal.payments.Authorization;
import com.paypal.payments.Capture;
import com.paypal.payments.CaptureRequest;
import com.paypal.payments.Money;
import com.paypal.payments.Refund;
import com.paypal.payments.RefundRequest;
import jakarta.annotation.Resource;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayTransactionService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.exception.PayPalRESTException;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalAuthorizationRetrievalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalAuthorizationRetrievalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalAuthorizeRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalAuthorizeResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureAuthRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureAuthResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureOrderRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureOrderResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCheckoutPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalErrorResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRefundRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRefundResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalVoidAuthRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalVoidAuthResponse;
import org.broadleafcommerce.vendor.paypal.service.util.PayPalUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="blPayPalCheckoutTransactionService")
public class PayPalCheckoutTransactionServiceImpl
extends AbstractPaymentGatewayTransactionService
implements PaymentGatewayTransactionService {
    protected static final Log LOG = LogFactory.getLog(PayPalCheckoutTransactionServiceImpl.class);
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService payPalCheckoutService;
    @Resource(name="blPayPalClientProvider")
    protected PayPalClientProvider clientProvider;
    @Resource(name="blPayPalUtils")
    protected PayPalUtils utils;

    public PaymentResponseDTO authorize(PaymentRequestDTO paymentRequest) {
        PaymentResponseDTO paymentResponse = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT_V2).paymentTransactionType(PaymentTransactionType.AUTHORIZE);
        try {
            PayPalAuthorizeResponse response = this.authorizeOrder(paymentRequest);
            com.paypal.orders.Authorization authorization = response.getAuthorization();
            org.broadleafcommerce.common.money.Money amount = this.utils.convertOrdersMoneyToMoney(authorization.amount());
            HttpResponse result = response.getResponse();
            paymentResponse.successful(true).amount(amount).responseMap("AUTHORIZATIONID", authorization.id()).rawResponse(this.utils.convertResponseToJson(result));
        }
        catch (Exception e) {
            this.processException(e, paymentResponse, paymentRequest);
        }
        return paymentResponse;
    }

    public PaymentResponseDTO capture(PaymentRequestDTO paymentRequest) {
        PaymentResponseDTO paymentResponse = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT_V2).paymentTransactionType(PaymentTransactionType.CAPTURE);
        try {
            PayPalCaptureAuthResponse response = this.captureAuthorization(paymentRequest);
            Capture capture = (Capture)response.getContent();
            Money amount = capture.amount();
            org.broadleafcommerce.common.money.Money finalAmount = amount == null ? new org.broadleafcommerce.common.money.Money(paymentRequest.getTransactionTotal(), paymentRequest.getOrderCurrencyCode()) : this.utils.convertPaymentsMoneyToMoney(amount);
            paymentResponse.successful(true).rawResponse(this.utils.convertResponseToJson(response.getResponse())).responseMap("CAPTUREID", capture.id()).amount(finalAmount);
        }
        catch (PaymentException e) {
            this.processException((Exception)((Object)e), paymentResponse, paymentRequest);
        }
        return paymentResponse;
    }

    public PaymentResponseDTO authorizeAndCapture(PaymentRequestDTO paymentRequest) {
        PaymentResponseDTO paymentResponse = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT_V2).paymentTransactionType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
        try {
            PayPalCaptureOrderResponse response = this.captureOrder(paymentRequest);
            Order order = (Order)response.getContent();
            PurchaseUnit purchaseUnit = (PurchaseUnit)order.purchaseUnits().get(0);
            AmountWithBreakdown amountWithBreakdown = purchaseUnit.amountWithBreakdown();
            org.broadleafcommerce.common.money.Money finalAmount = amountWithBreakdown == null ? new org.broadleafcommerce.common.money.Money(paymentRequest.getTransactionTotal(), paymentRequest.getOrderCurrencyCode()) : this.utils.getMoneyForAmountWithBreakdown(amountWithBreakdown);
            String captureId = Optional.ofNullable(purchaseUnit.payments()).map(PaymentCollection::captures).map(captures -> (com.paypal.orders.Capture)captures.get(0)).map(com.paypal.orders.Capture::id).orElse("");
            paymentResponse.successful(true).rawResponse(this.utils.convertResponseToJson(response.getResponse())).responseMap("CAPTUREID", captureId).amount(finalAmount);
        }
        catch (PaymentException e) {
            this.processException((Exception)((Object)e), paymentResponse, paymentRequest);
        }
        return paymentResponse;
    }

    public PaymentResponseDTO reverseAuthorize(PaymentRequestDTO paymentRequest) {
        return this.voidAuthorization(paymentRequest, PaymentTransactionType.REVERSE_AUTH);
    }

    public PaymentResponseDTO voidPayment(PaymentRequestDTO paymentRequest) {
        return this.voidAuthorization(paymentRequest, PaymentTransactionType.VOID);
    }

    public PaymentResponseDTO refund(PaymentRequestDTO paymentRequest) {
        PaymentResponseDTO paymentResponse = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT_V2).paymentTransactionType(PaymentTransactionType.REFUND);
        String captureId = this.getCaptureId(paymentRequest);
        try {
            if (StringUtils.isBlank((CharSequence)captureId)) {
                throw new PaymentException("Unable to perform refund. Unable to find corresponding capture transaction.");
            }
            PayPalRefundResponse response = this.refundPayment(paymentRequest);
            Refund refund = (Refund)response.getContent();
            Money amount = refund.amount();
            org.broadleafcommerce.common.money.Money finalAmount = amount == null ? new org.broadleafcommerce.common.money.Money(paymentRequest.getTransactionTotal(), paymentRequest.getOrderCurrencyCode()) : this.utils.convertPaymentsMoneyToMoney(amount);
            paymentResponse.successful(true).rawResponse(this.utils.convertResponseToJson(response.getResponse())).responseMap("REFUNDID", refund.id()).responseMap("CAPTUREID", captureId).amount(finalAmount);
        }
        catch (PaymentException e) {
            this.processException((Exception)((Object)e), paymentResponse, paymentRequest);
        }
        return paymentResponse;
    }

    protected PaymentResponseDTO voidAuthorization(PaymentRequestDTO paymentRequest, PaymentTransactionType transactionType) {
        PaymentResponseDTO paymentResponse = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT_V2).paymentTransactionType(transactionType);
        try {
            this.voidAuthorization(paymentRequest);
            PayPalAuthorizationRetrievalResponse response = this.retrieveAuthorization(paymentRequest);
            Authorization auth = (Authorization)response.getContent();
            Money amount = auth.amount();
            org.broadleafcommerce.common.money.Money finalAmount = amount == null ? new org.broadleafcommerce.common.money.Money(paymentRequest.getTransactionTotal(), paymentRequest.getOrderCurrencyCode()) : this.utils.convertPaymentsMoneyToMoney(amount);
            paymentResponse.successful(true).amount(finalAmount).rawResponse(this.utils.convertResponseToJson(response.getResponse()));
        }
        catch (PaymentException e) {
            this.processException((Exception)((Object)e), paymentResponse, paymentRequest);
        }
        return paymentResponse;
    }

    protected PayPalCaptureAuthResponse captureAuthorization(PaymentRequestDTO paymentRequest) throws PaymentException {
        String authId = this.getAuthorizationId(paymentRequest);
        CaptureRequest capture = new CaptureRequest();
        Money amount = this.utils.convertToPaymentsMoney(paymentRequest.getTransactionTotal(), paymentRequest.getOrderCurrencyCode());
        capture.amount(amount);
        PayPalCaptureAuthRequest captureRequest = new PayPalCaptureAuthRequest(this.clientProvider, paymentRequest, capture, authId);
        return this.payPalCheckoutService.call(captureRequest, PayPalCaptureAuthResponse.class);
    }

    protected PayPalAuthorizeResponse authorizeOrder(PaymentRequestDTO paymentRequest) throws PaymentException {
        String orderId = this.getOrderId(paymentRequest);
        PayPalAuthorizeRequest authorizeRequest = new PayPalAuthorizeRequest(this.clientProvider, paymentRequest, orderId);
        return this.payPalCheckoutService.call(authorizeRequest, PayPalAuthorizeResponse.class);
    }

    protected PayPalAuthorizationRetrievalResponse retrieveAuthorization(PaymentRequestDTO paymentRequest) throws PaymentException {
        String authId = this.getAuthorizationId(paymentRequest);
        PayPalAuthorizationRetrievalRequest request = new PayPalAuthorizationRetrievalRequest(this.clientProvider, paymentRequest, authId);
        return this.payPalCheckoutService.call(request, PayPalAuthorizationRetrievalResponse.class);
    }

    protected PayPalCaptureOrderResponse captureOrder(PaymentRequestDTO paymentRequest) throws PaymentException {
        String orderId = this.getOrderId(paymentRequest);
        PayPalCaptureOrderRequest authorizeRequest = new PayPalCaptureOrderRequest(this.clientProvider, paymentRequest, orderId);
        return this.payPalCheckoutService.call(authorizeRequest, PayPalCaptureOrderResponse.class);
    }

    protected PayPalVoidAuthResponse voidAuthorization(PaymentRequestDTO paymentRequest) throws PaymentException {
        String authId = this.getAuthorizationId(paymentRequest);
        PayPalVoidAuthRequest voidRequest = new PayPalVoidAuthRequest(this.clientProvider, paymentRequest, authId);
        return this.payPalCheckoutService.call(voidRequest, PayPalVoidAuthResponse.class);
    }

    protected PayPalRefundResponse refundPayment(PaymentRequestDTO paymentRequest) throws PaymentException {
        String captureId = this.getCaptureId(paymentRequest);
        RefundRequest refund = new RefundRequest();
        refund.amount(this.utils.convertToPaymentsMoney(paymentRequest.getTransactionTotal(), paymentRequest.getOrderCurrencyCode()));
        PayPalRefundRequest refundRequest = new PayPalRefundRequest(this.clientProvider, paymentRequest, refund, captureId);
        return this.payPalCheckoutService.call(refundRequest, PayPalRefundResponse.class);
    }

    private String getOrderId(PaymentRequestDTO paymentRequest) {
        return (String)paymentRequest.getAdditionalFields().get("ORDER_ID");
    }

    private String getAuthorizationId(PaymentRequestDTO paymentRequest) {
        return (String)paymentRequest.getAdditionalFields().get("AUTHORIZATIONID");
    }

    @Nullable
    private String getCaptureId(PaymentRequestDTO paymentRequest) {
        return (String)paymentRequest.getAdditionalFields().get("CAPTUREID");
    }

    protected void processException(Exception e, PaymentResponseDTO paymentResponse, PaymentRequestDTO paymentRequest) {
        paymentResponse.successful(false);
        Throwable cause = e.getCause();
        if (!(cause instanceof PayPalRESTException)) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        PayPalRESTException restException = (PayPalRESTException)cause;
        HttpException httpException = (HttpException)restException.getCause();
        PayPalErrorResponse error = this.utils.convertFromErrorJson(httpException);
        String message = error.getMessage();
        String errorName = error.getName();
        int httpCode = httpException.statusCode();
        paymentResponse.rawResponse(httpException.getMessage());
        paymentResponse.responseMap("EXCEPTION_NAME", errorName);
        paymentResponse.responseMap("EXCEPTION_MESSAGE", error.getMessage());
        paymentResponse.responseMap("EXCEPTION_DEBUG_ID", error.getDebugId());
        if (400 == httpCode) {
            String errorMessage = String.format("An invalid request was supplied to PayPal's API. Exception message: %s", message);
            paymentResponse.responseMap("EXCEPTION_MESSAGE", errorMessage);
            LOG.error((Object)"An invalid request was supplied to PayPal's API", (Throwable)e);
            return;
        }
        if (401 == httpCode) {
            String errorMessage = String.format("Authentication with PayPal's API failed. Maybe you changed client id or client secret recently. Exception message: %s", message);
            paymentResponse.responseMap("EXCEPTION_MESSAGE", errorMessage);
            LOG.error((Object)"Authentication with PayPal's API failed. Maybe you changed client id or client secret recently", (Throwable)e);
            return;
        }
        if (403 == httpCode) {
            String errorMessage = String.format("PayPal authorization failed due to insufficient permissions.. Exception message: %s", message);
            paymentResponse.responseMap("EXCEPTION_MESSAGE", errorMessage);
            LOG.error((Object)"PayPal authorization failed due to insufficient permissions", (Throwable)e);
            return;
        }
        if (408 == httpCode) {
            String errorMessage = String.format("Network communication with Stripe failed. Exception message: %s", message);
            paymentResponse.responseMap("EXCEPTION_MESSAGE", errorMessage);
            LOG.error((Object)"Network communication with Stripe failed", (Throwable)e);
            return;
        }
        if (429 == httpCode && "RATE_LIMIT_REACHED".equals(errorName)) {
            String errorMessage = String.format("Too many requests made to the PayPal API too quickly. Exception message: %s", message);
            paymentResponse.responseMap("EXCEPTION_MESSAGE", errorMessage);
            LOG.warn((Object)"Too many requests made to the PayPal API too quickly", (Throwable)e);
            return;
        }
        String errorMessage = String.format("An invalid request was supplied to PayPal's API. Exception message: %s", message);
        paymentResponse.responseMap("EXCEPTION_MESSAGE", errorMessage);
        LOG.error((Object)"An invalid request was supplied to PayPal's API", (Throwable)e);
    }
}

