/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import jakarta.annotation.Resource;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayTransactionConfirmationService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionConfirmationService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.PayPalCheckoutConfiguration;
import org.springframework.stereotype.Service;

@Service(value="blPayPalCheckoutTransactionConfirmationService")
public class PayPalCheckoutTransactionConfirmationServiceImpl
extends AbstractPaymentGatewayTransactionConfirmationService
implements PaymentGatewayTransactionConfirmationService {
    @Resource(name="blPayPalCheckoutConfiguration")
    protected PayPalCheckoutConfiguration configuration;
    @Resource(name="blPayPalCheckoutTransactionService")
    protected PaymentGatewayTransactionService transactionService;

    public PaymentResponseDTO confirmTransaction(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = null;
        if (this.configuration.isPerformAuthorizeAndCapture()) {
            responseDTO = this.transactionService.authorizeAndCapture(paymentRequestDTO);
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
        } else {
            responseDTO = this.transactionService.authorize(paymentRequestDTO);
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE);
        }
        return responseDTO;
    }
}

