/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import com.paypal.orders.AddressPortable;
import com.paypal.orders.AmountBreakdown;
import com.paypal.orders.AmountWithBreakdown;
import com.paypal.orders.Money;
import com.paypal.orders.Name;
import com.paypal.orders.Order;
import com.paypal.orders.Payer;
import com.paypal.orders.Phone;
import com.paypal.orders.PhoneWithType;
import com.paypal.orders.PurchaseUnit;
import com.paypal.orders.ShippingDetail;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayReportingService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayReportingService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.PayPalClientProvider;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCheckoutPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalOrderRetrievalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalOrderRetrievalResponse;
import org.broadleafcommerce.vendor.paypal.service.util.PayPalUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="blPayPalCheckoutReportingService")
public class PayPalCheckoutReportingServiceImpl
extends AbstractPaymentGatewayReportingService
implements PaymentGatewayReportingService {
    private static final Log LOG = LogFactory.getLog(PayPalCheckoutReportingServiceImpl.class);
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService payPalCheckoutService;
    @Resource(name="blPayPalClientProvider")
    protected PayPalClientProvider clientProvider;
    @Resource(name="blPayPalUtils")
    protected PayPalUtils utils;

    public PaymentResponseDTO findDetailsByTransaction(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Map additionalFields = paymentRequestDTO.getAdditionalFields();
        Assert.isTrue((boolean)additionalFields.containsKey("payerId"), (String)"The RequestDTO must contain a payerID");
        Assert.isTrue((boolean)additionalFields.containsKey("orderId"), (String)"The RequestDTO must contain a orderId");
        String orderId = (String)additionalFields.get("orderId");
        PayPalOrderRetrievalRequest orderRetrievalRequest = new PayPalOrderRetrievalRequest(this.clientProvider, paymentRequestDTO, orderId);
        PayPalOrderRetrievalResponse response = this.payPalCheckoutService.call(orderRetrievalRequest, PayPalOrderRetrievalResponse.class);
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT_V2);
        this.setCommonDetailsResponse(response, responseDTO);
        String payerId = (String)additionalFields.get("payerId");
        responseDTO.orderId(paymentRequestDTO.getOrderId());
        responseDTO.responseMap("PAYERID", payerId).responseMap("ORDER_ID", orderId);
        LOG.info((Object)("ResponseDTO created: " + ToStringBuilder.reflectionToString((Object)responseDTO, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
        return responseDTO;
    }

    protected void setCommonDetailsResponse(PayPalOrderRetrievalResponse response, PaymentResponseDTO responseDTO) {
        Order order = (Order)response.getContent();
        responseDTO.rawResponse(this.utils.convertResponseToJson(response.getResponse()));
        responseDTO.responseMap("ORDER_STATUS", order.status());
        List purchaseUnits = order.purchaseUnits();
        if (CollectionUtils.isEmpty((Collection)purchaseUnits) || purchaseUnits.get(0) == null) {
            return;
        }
        PurchaseUnit purchaseUnit = (PurchaseUnit)purchaseUnits.get(0);
        ShippingDetail shippingDetail = purchaseUnit.shippingDetail();
        String phone = Optional.ofNullable(order.payer()).map(Payer::phoneWithType).map(PhoneWithType::phoneNumber).map(Phone::nationalNumber).orElse("");
        if (shippingDetail != null) {
            AddressPortable shipAddress = shippingDetail.addressPortable();
            responseDTO.shipTo().addressFullName(shippingDetail.name().fullName()).addressLine1(shipAddress.addressLine1()).addressLine2(shipAddress.addressLine2()).addressCityLocality(shipAddress.adminArea2()).addressStateRegion(shipAddress.adminArea1()).addressPostalCode(shipAddress.postalCode()).addressCountryCode(shipAddress.countryCode()).addressPhone(phone).done();
        }
        String itemTotal = this.getItemTotal(purchaseUnit);
        String shippingDiscount = this.getShippingDiscount(purchaseUnit);
        String shippingTotal = this.getShippingTotal(purchaseUnit);
        String totalTax = this.getTotalTax(purchaseUnit);
        AmountWithBreakdown amountWithBreakdown = purchaseUnit.amountWithBreakdown();
        org.broadleafcommerce.common.money.Money amount = new org.broadleafcommerce.common.money.Money(amountWithBreakdown.value(), amountWithBreakdown.currencyCode());
        String[] customFields = purchaseUnit.customId().split("\\|");
        responseDTO.amount(amount).successful(true).valid(true).completeCheckoutOnCallback(Boolean.parseBoolean(customFields[1])).responseMap("PAYMENTREQUEST_n_TRANSACTIONID", purchaseUnit.id()).responseMap("PAYMENTREQUEST_n_ITEMAMT", itemTotal).responseMap("PAYMENTREQUEST_n_SHIPDISCAMT", shippingDiscount).responseMap("PAYMENTREQUEST_n_SHIPPINGAMT", shippingTotal).responseMap("PAYMENTREQUEST_n_TAXAMT", totalTax);
        Payer payer = order.payer();
        if (payer != null) {
            responseDTO.customer().firstName(Optional.ofNullable(payer.name()).map(Name::givenName).orElse("")).lastName(Optional.ofNullable(payer.name()).map(Name::surname).orElse("")).phone(phone).email(payer.email()).done();
        }
    }

    @Nullable
    private String getItemTotal(PurchaseUnit purchaseUnit) {
        return Optional.of(purchaseUnit).map(PurchaseUnit::amountWithBreakdown).map(AmountWithBreakdown::amountBreakdown).map(AmountBreakdown::itemTotal).map(Money::value).orElse(null);
    }

    @Nullable
    private String getShippingDiscount(PurchaseUnit purchaseUnit) {
        return Optional.of(purchaseUnit).map(PurchaseUnit::amountWithBreakdown).map(AmountWithBreakdown::amountBreakdown).map(AmountBreakdown::shippingDiscount).map(Money::value).orElse(null);
    }

    @Nullable
    private String getShippingTotal(PurchaseUnit purchaseUnit) {
        return Optional.of(purchaseUnit).map(PurchaseUnit::amountWithBreakdown).map(AmountWithBreakdown::amountBreakdown).map(AmountBreakdown::shipping).map(Money::value).orElse(null);
    }

    @Nullable
    private String getTotalTax(PurchaseUnit purchaseUnit) {
        return Optional.of(purchaseUnit).map(PurchaseUnit::amountWithBreakdown).map(AmountWithBreakdown::amountBreakdown).map(AmountBreakdown::taxTotal).map(Money::value).orElse(null);
    }
}

