/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayConfiguration;
import org.broadleafcommerce.payment.service.gateway.PayPalCheckoutConfiguration;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCheckoutPaymentGatewayType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="blPayPalCheckoutConfiguration")
public class PayPalCheckoutConfigurationImpl
extends AbstractPaymentGatewayConfiguration
implements PayPalCheckoutConfiguration {
    @Autowired
    protected Environment env;
    protected int failureReportingThreshold = 1;
    protected boolean performAuthorizeAndCapture = true;

    @Override
    public String getPaymentDescription() {
        return this.env.getProperty("gateway.paypal.checkout.api.description");
    }

    @Override
    public String getEnvironment() {
        return this.env.getProperty("gateway.paypal.checkout.api.environment");
    }

    @Override
    public String getTotalType() {
        return "Total";
    }

    @Override
    public Map<String, String> getAdditionalConfig() {
        HashMap<String, String> additionalConfigs = new HashMap<String, String>();
        additionalConfigs.put("HDRBORDERCOLOR", "FFFFFF");
        additionalConfigs.put("HDRBACKCOLOR", "FFFFFF");
        additionalConfigs.put("PAYFLOWCOLOR", "FFFFFF");
        return additionalConfigs;
    }

    @Override
    public Map<String, String> getAdditionalCustomFields() {
        return new HashMap<String, String>();
    }

    @Override
    public String getClientId() {
        return this.env.getProperty("gateway.paypal.checkout.api.clientId");
    }

    @Override
    public String getClientSecret() {
        return this.env.getProperty("gateway.paypal.checkout.api.secret");
    }

    public boolean handlesAuthorize() {
        return true;
    }

    public boolean handlesCapture() {
        return true;
    }

    public boolean handlesAuthorizeAndCapture() {
        return true;
    }

    public boolean handlesReverseAuthorize() {
        return true;
    }

    public boolean handlesVoid() {
        return true;
    }

    public boolean handlesRefund() {
        return true;
    }

    public boolean handlesPartialCapture() {
        return false;
    }

    public boolean handlesMultipleShipment() {
        return false;
    }

    public boolean handlesRecurringPayment() {
        return false;
    }

    public boolean handlesSavedCustomerPayment() {
        return false;
    }

    public boolean isPerformAuthorizeAndCapture() {
        return this.performAuthorizeAndCapture;
    }

    public void setPerformAuthorizeAndCapture(boolean performAuthorizeAndCapture) {
        this.performAuthorizeAndCapture = performAuthorizeAndCapture;
    }

    public int getFailureReportingThreshold() {
        return this.failureReportingThreshold;
    }

    public void setFailureReportingThreshold(int failureReportingThreshold) {
        this.failureReportingThreshold = failureReportingThreshold;
    }

    public boolean handlesMultiplePayments() {
        return false;
    }

    public PaymentGatewayType getGatewayType() {
        return PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT_V2;
    }
}

