/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.IdGenerationImpl;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.dataprovider.CustomerDataProvider;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class CustomerTest
extends BaseTest {
    @Resource
    private CustomerService customerService;
    List<Long> userIds = new ArrayList<Long>();
    List<String> userNames = new ArrayList<String>();

    @Test(groups={"createCustomerIdGeneration"})
    @Rollback(value=false)
    @Transactional
    public void createCustomerIdGeneration() {
        IdGenerationImpl gen = (IdGenerationImpl)this.em.find(IdGenerationImpl.class, (Object)"org.broadleafcommerce.profile.core.domain.Customer");
        if (gen == null) {
            IdGenerationImpl idGeneration = new IdGenerationImpl();
            idGeneration.setType("org.broadleafcommerce.profile.core.domain.Customer");
            idGeneration.setBatchStart(Long.valueOf(1L));
            idGeneration.setBatchSize(Long.valueOf(10L));
            this.em.persist((Object)idGeneration);
        }
    }

    @Test(groups={"createCustomers"}, dependsOnGroups={"createCustomerIdGeneration"}, dataProvider="setupCustomers", dataProviderClass=CustomerDataProvider.class)
    @Rollback(value=false)
    public void createCustomer(Customer customerInfo) {
        Customer customer = this.customerService.createCustomerFromId(null);
        customer.setPassword(customerInfo.getPassword());
        customer.setUsername(customerInfo.getUsername());
        Long customerId = customer.getId();
        assert (customerId != null);
        customer = this.customerService.saveCustomer(customer);
        assert (customer.getId() == customerId);
        this.userIds.add(customer.getId());
        this.userNames.add(customer.getUsername());
    }

    @Test(groups={"readCustomer"}, dependsOnGroups={"createCustomers"})
    public void readCustomersById() {
        for (Long userId : this.userIds) {
            Customer customer = this.customerService.readCustomerById(userId);
            assert (customer.getId() == userId);
        }
    }

    @Test(groups={"changeCustomerPassword"}, dependsOnGroups={"readCustomer"})
    @Transactional
    @Rollback(value=false)
    public void changeCustomerPasswords() {
        for (String userName : this.userNames) {
            Customer customer = this.customerService.readCustomerByUsername(userName);
            customer.setPassword(customer.getPassword() + "-Changed");
            this.customerService.saveCustomer(customer);
        }
    }
}

