/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.broadleafcommerce.profile.core.service.CustomerPhoneService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.dataprovider.CustomerPhoneDataProvider;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class CustomerPhoneTest
extends BaseTest {
    List<Long> customerPhoneIds = new ArrayList<Long>();
    String userName = new String();
    Long userId;
    @Resource
    private CustomerPhoneService customerPhoneService;
    @Resource
    private CustomerService customerService;

    @Test(groups={"createCustomerPhone"}, dataProvider="setupCustomerPhone", dataProviderClass=CustomerPhoneDataProvider.class, dependsOnGroups={"readCustomer"})
    @Transactional
    @Rollback(value=false)
    public void createCustomerPhone(CustomerPhone customerPhone) {
        this.userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(this.userName);
        assert (customerPhone.getId() == null);
        customerPhone.setCustomer(customer);
        PhoneImpl phone = new PhoneImpl();
        phone.setPhoneNumber("214-214-2134");
        customerPhone.setPhone((Phone)phone);
        customerPhone = this.customerPhoneService.saveCustomerPhone(customerPhone);
        assert (customer.equals(customerPhone.getCustomer()));
        this.userId = customerPhone.getCustomer().getId();
    }

    @Test(groups={"readCustomerPhone"}, dependsOnGroups={"createCustomerPhone"})
    @Transactional
    public void readCustomerPhoneByUserId() {
        List customerPhoneList = this.customerPhoneService.readActiveCustomerPhonesByCustomerId(this.userId);
        for (CustomerPhone customerPhone : customerPhoneList) {
            assert (customerPhone != null);
        }
    }

    @Test(groups={"readCustomerPhone"}, dependsOnGroups={"createCustomerPhone"})
    @Transactional
    public void readDeafultCustomerPhoneByUserId() {
        CustomerPhone customerPhone = this.customerPhoneService.findDefaultCustomerPhone(this.userId);
        assert (customerPhone != null);
    }
}

