/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.test;

import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.web.extensibility.MergeXmlWebApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.WebApplicationContext;

public class BroadleafGenericGroovyXmlWebContextLoader
extends AbstractContextLoader {
    protected String[] getResourceSuffixes() {
        return new String[]{"-context.xml", "Context.groovy"};
    }

    protected String getResourceSuffix() {
        throw new UnsupportedOperationException("BroadleafGenericGroovyXmlWebContextLoader does not support the getResourceSuffix() method");
    }

    protected void validateMergedContextConfiguration(WebMergedContextConfiguration webMergedConfig) {
        if (webMergedConfig.hasClasses()) {
            String msg = String.format("Test class [%s] has been configured with @ContextConfiguration's 'classes' attribute %s, but %s does not support annotated classes.", webMergedConfig.getTestClass().getName(), ObjectUtils.nullSafeToString((Object[])webMergedConfig.getClasses()), ((Object)((Object)this)).getClass().getSimpleName());
            throw new IllegalStateException(msg);
        }
    }

    public final ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("BroadleafGenericGroovyXmlWebContextLoader does not support the loadContext(String... locations) method");
    }

    public ConfigurableApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        if (!(mergedConfig instanceof WebMergedContextConfiguration)) {
            throw new IllegalArgumentException(String.format("Cannot load WebApplicationContext from non-web merged context configuration %s. Consider annotating your test class with @WebAppConfiguration.", mergedConfig));
        }
        WebMergedContextConfiguration webMergedConfig = (WebMergedContextConfiguration)mergedConfig;
        this.validateMergedContextConfiguration(webMergedConfig);
        MergeXmlWebApplicationContext context = new MergeXmlWebApplicationContext();
        context.setPatchLocation("");
        ApplicationContext parent = mergedConfig.getParentApplicationContext();
        if (parent != null) {
            context.setParent(parent);
            context.setPatchLocation(StringUtils.removeEnd((String)((MergeXmlWebApplicationContext)parent).getPatchLocation(), (String)"classpath:/bl-applicationContext-test.xml"));
            System.out.println(context.getPatchLocation());
        }
        context.setPatchLocation(context.getPatchLocation() + StringUtils.join((Object[])mergedConfig.getLocations(), (String)";") + ";classpath:/bl-applicationContext-test.xml");
        context.setStandardLocationTypes(3);
        this.configureWebResources(context, webMergedConfig);
        this.prepareContext((ConfigurableApplicationContext)context, (MergedContextConfiguration)webMergedConfig);
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    protected void configureWebResources(MergeXmlWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        ApplicationContext parent = context.getParent();
        if (parent == null || !(parent instanceof WebApplicationContext)) {
            String resourceBasePath = webMergedConfig.getResourceBasePath();
            DefaultResourceLoader resourceLoader = resourceBasePath.startsWith("classpath:") ? new DefaultResourceLoader() : new FileSystemResourceLoader();
            MockServletContext servletContext = new MockServletContext(resourceBasePath, (ResourceLoader)resourceLoader);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
            context.setServletContext((ServletContext)servletContext);
        } else {
            ServletContext servletContext = null;
            while (parent != null) {
                if (parent instanceof WebApplicationContext && !(parent.getParent() instanceof WebApplicationContext)) {
                    servletContext = ((WebApplicationContext)parent).getServletContext();
                    break;
                }
                parent = parent.getParent();
            }
            Assert.state((servletContext != null ? 1 : 0) != 0, (String)"Failed to find Root MergeXmlWebApplicationContext in the context hierarchy");
            context.setServletContext(servletContext);
        }
    }
}

