/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.domain.IdGenerationImpl;
import org.broadleafcommerce.profile.core.service.IdGenerationService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class IdGenerationTest
extends BaseTest {
    @Resource
    private IdGenerationService idGenerationService;
    List<Long> userIds = new ArrayList<Long>();
    List<String> userNames = new ArrayList<String>();

    @Test(groups={"createId"})
    @Rollback(value=false)
    @Transactional
    public void createId() {
        IdGenerationImpl idGeneration = new IdGenerationImpl();
        idGeneration.setType("IdGenerationTest");
        idGeneration.setBatchStart(Long.valueOf(1L));
        idGeneration.setBatchSize(Long.valueOf(10L));
        this.em.persist((Object)idGeneration);
    }

    @Test(groups={"findIds"}, dependsOnGroups={"createId"})
    @Rollback(value=true)
    public void findIds() {
        for (int i = 1; i < 101; ++i) {
            Long id = this.idGenerationService.findNextId("IdGenerationTest");
            assert (id == (long)i);
        }
    }

    @Test(groups={"createIdForBeginEndSequence"})
    @Rollback(value=false)
    @Transactional
    public void createIdForBeginEndSequence() {
        IdGenerationImpl idGeneration = new IdGenerationImpl();
        idGeneration.setType("IdGenerationBeginEndTest");
        idGeneration.setBegin(Long.valueOf(1L));
        idGeneration.setEnd(Long.valueOf(10L));
        idGeneration.setBatchStart(Long.valueOf(1L));
        idGeneration.setBatchSize(Long.valueOf(3L));
        this.em.persist((Object)idGeneration);
    }

    @Test(groups={"findIdsForBeginEndSequence"}, dependsOnGroups={"createIdForBeginEndSequence"})
    @Rollback(value=true)
    public void findIdsForBeginEndSequence() {
        for (int i = 1; i < 101; ++i) {
            Long id = this.idGenerationService.findNextId("IdGenerationBeginEndTest");
            int expected = i % 10;
            if (expected == 0) {
                expected = 10;
            }
            assert (id == (long)expected);
        }
    }
}

