/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.controller;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.broadleafcommerce.profile.core.service.CustomerPhoneService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.controller.CustomerPhoneController;
import org.broadleafcommerce.profile.web.core.controller.dataprovider.CustomerPhoneControllerTestDataProvider;
import org.broadleafcommerce.profile.web.core.model.PhoneNameForm;
import org.broadleafcommerce.profile.web.core.security.CustomerStateRequestProcessor;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.testng.annotations.Test;

public class CustomerPhoneControllerTest
extends BaseTest {
    @Resource
    private CustomerPhoneController customerPhoneController;
    @Resource
    private CustomerPhoneService customerPhoneService;
    @Resource
    private CustomerService customerService;
    private final List<Long> createdCustomerPhoneIds = new ArrayList<Long>();
    private final Long userId = 1L;
    private MockHttpServletRequest request;
    private static final String SUCCESS = "customerPhones";

    @Test(groups={"createCustomerPhoneFromController"}, dataProvider="setupCustomerPhoneControllerData", dataProviderClass=CustomerPhoneControllerTestDataProvider.class, dependsOnGroups={"readCustomer"})
    @Transactional
    @Rollback(value=false)
    public void createCustomerPhoneFromController(PhoneNameForm phoneNameForm) {
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult((Object)phoneNameForm, "phoneNameForm");
        Customer customer = this.customerService.readCustomerById(this.userId);
        this.request = this.getNewServletInstance();
        this.request.setAttribute(CustomerStateRequestProcessor.getCustomerRequestAttributeName(), (Object)customer);
        String view = this.customerPhoneController.savePhone(phoneNameForm, (BindingResult)errors, (HttpServletRequest)this.request, null, null);
        assert (view.indexOf(SUCCESS) >= 0);
        List phones = this.customerPhoneService.readAllCustomerPhonesByCustomerId(Long.valueOf(1L));
        boolean inPhoneList = false;
        Long id = (Long)this.request.getAttribute("customerPhoneId");
        assert (id != null);
        for (CustomerPhone p : phones) {
            if (p.getPhoneName() == null || !p.getPhoneName().equals(phoneNameForm.getPhoneName())) continue;
            inPhoneList = true;
        }
        assert (inPhoneList);
        this.createdCustomerPhoneIds.add(id);
    }

    @Test(groups={"makePhoneDefaultOnCustomerPhoneController"}, dependsOnGroups={"createCustomerPhoneFromController"})
    @Transactional
    public void makePhoneDefaultOnCustomerPhoneController() {
        Long nonDefaultPhoneId = null;
        List phones_1 = this.customerPhoneService.readAllCustomerPhonesByCustomerId(Long.valueOf(1L));
        for (CustomerPhone p : phones_1) {
            if (p.getPhone().isDefault()) continue;
            nonDefaultPhoneId = p.getId();
            break;
        }
        this.request = this.getNewServletInstance();
        String view = this.customerPhoneController.makePhoneDefault(nonDefaultPhoneId, (HttpServletRequest)this.request);
        assert (view.indexOf("viewPhone") >= 0);
        List phones = this.customerPhoneService.readAllCustomerPhonesByCustomerId(Long.valueOf(1L));
        for (CustomerPhone p : phones) {
            if (p.getId() != nonDefaultPhoneId) continue;
            assert (p.getPhone().isDefault());
            break;
        }
    }

    @Test(groups={"readCustomerPhoneFromController"}, dependsOnGroups={"createCustomerPhoneFromController"})
    @Transactional
    public void readCustomerPhoneFromController() {
        List phones_1 = this.customerPhoneService.readAllCustomerPhonesByCustomerId(Long.valueOf(1L));
        int phones_1_size = phones_1.size();
        this.request = this.getNewServletInstance();
        String view = this.customerPhoneController.deletePhone(this.createdCustomerPhoneIds.get(0), (HttpServletRequest)this.request);
        assert (view.indexOf("viewPhone") >= 0);
        List phones_2 = this.customerPhoneService.readAllCustomerPhonesByCustomerId(Long.valueOf(1L));
        assert (phones_1_size - phones_2.size() == 1);
    }

    @Test(groups={"viewCustomerPhoneFromController"})
    public void viewCustomerPhoneFromController() {
        PhoneNameForm pnf = new PhoneNameForm();
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult((Object)pnf, "phoneNameForm");
        this.request = this.getNewServletInstance();
        String view = this.customerPhoneController.viewPhone(null, (HttpServletRequest)this.request, pnf, (BindingResult)errors);
        assert (view.indexOf(SUCCESS) >= 0);
        assert (this.request.getAttribute("customerPhoneId") == null);
    }

    @Test(groups={"viewExistingCustomerPhoneFromController"}, dependsOnGroups={"createCustomerPhoneFromController"})
    @Transactional
    public void viewExistingCustomerPhoneFromController() {
        List phones_1 = this.customerPhoneService.readAllCustomerPhonesByCustomerId(Long.valueOf(1L));
        PhoneNameForm pnf = new PhoneNameForm();
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult((Object)pnf, "phoneNameForm");
        Customer customer = this.customerService.readCustomerById(this.userId);
        this.request = this.getNewServletInstance();
        this.request.setAttribute(CustomerStateRequestProcessor.getCustomerRequestAttributeName(), (Object)customer);
        String view = this.customerPhoneController.viewPhone(((CustomerPhone)phones_1.get(0)).getId(), (HttpServletRequest)this.request, pnf, (BindingResult)errors);
        assert (view.indexOf(SUCCESS) >= 0);
        assert (this.request.getAttribute("customerPhoneId").equals(((CustomerPhone)phones_1.get(0)).getId()));
    }

    private MockHttpServletRequest getNewServletInstance() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute("customer_session", (Object)this.userId);
        return request;
    }
}

