/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.OrderItemDataProvider;
import org.broadleafcommerce.core.order.dao.OrderItemDao;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class OrderItemDaoTest
extends BaseTest {
    private Long orderItemId;
    private Long giftWrapItemId;
    @Resource
    private OrderItemDao orderItemDao;
    @Resource
    private SkuDao skuDao;

    @Test(groups={"createDiscreteOrderItem"}, dataProvider="basicDiscreteOrderItem", dataProviderClass=OrderItemDataProvider.class, dependsOnGroups={"createOrder", "createSku"})
    @Rollback(value=false)
    @Transactional
    public void createDiscreteOrderItem(DiscreteOrderItem orderItem) {
        Sku si = this.skuDao.readFirstSku();
        assert (si.getId() != null);
        orderItem.setSku(si);
        assert (orderItem.getId() == null);
        orderItem = (DiscreteOrderItem)this.orderItemDao.save((OrderItem)orderItem);
        assert (orderItem.getId() != null);
        this.orderItemId = orderItem.getId();
    }

    @Test(groups={"createGiftWrapOrderItem"}, dataProvider="basicGiftWrapOrderItem", dataProviderClass=OrderItemDataProvider.class, dependsOnGroups={"readOrderItemsById"})
    @Rollback(value=false)
    @Transactional
    public void createGiftWrapOrderItem(GiftWrapOrderItem orderItem) {
        Sku si = this.skuDao.readFirstSku();
        assert (si.getId() != null);
        orderItem.setSku(si);
        assert (orderItem.getId() == null);
        OrderItem discreteItem = this.orderItemDao.readOrderItemById(this.orderItemId);
        orderItem.getWrappedItems().add(discreteItem);
        discreteItem.setGiftWrapOrderItem(orderItem);
        orderItem = (GiftWrapOrderItem)this.orderItemDao.save((OrderItem)orderItem);
        assert (orderItem.getId() != null);
        this.giftWrapItemId = orderItem.getId();
    }

    @Test(groups={"readGiftWrapOrderItemsById"}, dependsOnGroups={"createGiftWrapOrderItem"})
    @Transactional
    public void readGiftWrapOrderItemsById() {
        assert (this.giftWrapItemId != null);
        OrderItem result = this.orderItemDao.readOrderItemById(this.giftWrapItemId);
        assert (result != null);
        assert (result.getId().equals(this.giftWrapItemId));
        assert (((OrderItem)((GiftWrapOrderItem)result).getWrappedItems().get(0)).getId().equals(this.orderItemId));
    }

    @Test(groups={"deleteGiftWrapOrderItemsById"}, dependsOnGroups={"readGiftWrapOrderItemsById"})
    @Rollback(value=false)
    public void deleteGiftWrapOrderItemsById() {
        OrderItem result = this.orderItemDao.readOrderItemById(this.giftWrapItemId);
        this.orderItemDao.delete(result);
        assert (this.orderItemDao.readOrderItemById(this.giftWrapItemId) == null);
    }

    @Test(groups={"readOrderItemsById"}, dependsOnGroups={"createDiscreteOrderItem"})
    public void readOrderItemsById() {
        assert (this.orderItemId != null);
        OrderItem result = this.orderItemDao.readOrderItemById(this.orderItemId);
        assert (result != null);
        assert (result.getId().equals(this.orderItemId));
    }

    @Test(groups={"readOrderItemsByIdAfterGiftWrapDeletion"}, dependsOnGroups={"deleteGiftWrapOrderItemsById"})
    public void readOrderItemsByIdAfterGiftWrapDeletion() {
        assert (this.orderItemId != null);
        OrderItem result = this.orderItemDao.readOrderItemById(this.orderItemId);
        assert (result != null);
        assert (result.getId().equals(this.orderItemId));
        assert (result.getGiftWrapOrderItem() == null);
    }
}

