/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.media.domain.Media;
import org.broadleafcommerce.common.media.domain.MediaImpl;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryMediaXrefImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXrefImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryXrefImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class CatalogTest
extends BaseTest {
    @Resource
    private CatalogService catalogService;

    @Test(groups={"testCatalog"})
    @Transactional
    public void testCatalog() throws Exception {
        CategoryImpl category = new CategoryImpl();
        category.setName("Soaps");
        category = this.catalogService.saveCategory((Category)category);
        CategoryImpl category2 = new CategoryImpl();
        category2.setName("Towels");
        category2 = this.catalogService.saveCategory((Category)category2);
        CategoryImpl category3 = new CategoryImpl();
        category3.setName("SuperCategory");
        category3 = this.catalogService.saveCategory((Category)category3);
        CategoryXrefImpl temp = new CategoryXrefImpl();
        temp.setCategory((Category)category);
        temp.setSubCategory((Category)category3);
        category3.getAllParentCategoryXrefs().add(temp);
        category3 = this.catalogService.saveCategory((Category)category3);
        Long cat3Id = category3.getId();
        category3 = null;
        category3 = this.catalogService.findCategoryById(cat3Id);
        category3.getAllParentCategoryXrefs().clear();
        CategoryXrefImpl temp2 = new CategoryXrefImpl();
        temp2.setCategory((Category)category);
        temp2.setSubCategory((Category)category3);
        category3.getAllParentCategoryXrefs().add(temp2);
        CategoryXrefImpl temp3 = new CategoryXrefImpl();
        temp3.setCategory((Category)category2);
        temp3.setSubCategory((Category)category3);
        category3.getAllParentCategoryXrefs().add(temp3);
        category3 = this.catalogService.saveCategory((Category)category3);
        assert (category3.getAllParentCategoryXrefs().size() == 2);
        ProductImpl newProduct = new ProductImpl();
        SkuImpl newDefaultSku = new SkuImpl();
        newDefaultSku = this.catalogService.saveSku((Sku)newDefaultSku);
        newProduct.setDefaultSku((Sku)newDefaultSku);
        newProduct.setName("Lavender Soap");
        Calendar activeStartCal = Calendar.getInstance();
        activeStartCal.add(6, -2);
        newProduct.setActiveStartDate(activeStartCal.getTime());
        newProduct.setDefaultCategory((Category)category);
        newProduct.getAllParentCategoryXrefs().clear();
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        CategoryProductXrefImpl categoryXref = new CategoryProductXrefImpl();
        categoryXref.setProduct((Product)newProduct);
        categoryXref.setCategory((Category)category);
        newProduct.getAllParentCategoryXrefs().add(categoryXref);
        CategoryProductXrefImpl categoryXref2 = new CategoryProductXrefImpl();
        categoryXref2.setProduct((Product)newProduct);
        categoryXref2.setCategory((Category)category2);
        newProduct.getAllParentCategoryXrefs().add(categoryXref2);
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        Long newProductId = newProduct.getId();
        Product testProduct = this.catalogService.findProductById(newProductId);
        assert (testProduct.getId().equals(testProduct.getId()));
        Category testCategory = this.catalogService.findCategoryByName("Soaps");
        assert (testCategory.getId().equals(category.getId()));
        testCategory = this.catalogService.findCategoryById(category.getId());
        assert (testCategory.getId().equals(category.getId()));
        MediaImpl media = new MediaImpl();
        media.setAltText("test");
        media.setTitle("large");
        media.setUrl("http://myUrl");
        category.getCategoryMediaXref().put("large", new CategoryMediaXrefImpl((Category)category, (Media)media, "large"));
        this.catalogService.saveCategory(testCategory);
        testCategory = this.catalogService.findCategoryById(category.getId());
        assert (testCategory.getCategoryMediaXref().get("large") != null);
        List categories = this.catalogService.findAllCategories();
        assert (categories != null && categories.size() == 3);
        List products = this.catalogService.findAllProducts();
        boolean foundProduct = false;
        for (Product product : products) {
            if (!product.getId().equals(newProductId)) continue;
            foundProduct = true;
        }
        assert (foundProduct);
        products = this.catalogService.findProductsByName(newProduct.getName());
        foundProduct = false;
        for (Product product : products) {
            if (!product.getId().equals(newProductId)) continue;
            foundProduct = true;
        }
        assert (foundProduct);
        SkuImpl newSku = new SkuImpl();
        newSku.setName("Under Armor T-Shirt -- Red");
        newSku.setRetailPrice(new Money(14.99));
        newSku.setActiveStartDate(activeStartCal.getTime());
        newSku = this.catalogService.saveSku((Sku)newSku);
        ArrayList<SkuImpl> allSkus = new ArrayList<SkuImpl>();
        allSkus.add(newSku);
        newProduct.setAdditionalSkus(allSkus);
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        Long skuId = ((Sku)newProduct.getSkus().get(0)).getId();
        Sku testSku = this.catalogService.findSkuById(skuId);
        assert (testSku.getId().equals(skuId));
        List testSkus = this.catalogService.findAllSkus();
        boolean foundSku = false;
        for (Sku sku : testSkus) {
            if (!sku.getId().equals(skuId)) continue;
            foundSku = true;
        }
        assert (foundSku);
        ArrayList<Long> skuIds = new ArrayList<Long>();
        skuIds.add(skuId);
        testSkus = this.catalogService.findSkusByIds(skuIds);
        foundSku = false;
        for (Sku sku : testSkus) {
            if (!sku.getId().equals(skuId)) continue;
            foundSku = true;
        }
        assert (foundSku);
    }

    @Test
    public void testSkus() throws Exception {
        SkuImpl sku = new SkuImpl();
        String longDescription = "This is a great product that will help the Longhorns win.";
        String description = "This is a great product.";
        sku.setLongDescription(longDescription);
        assert (sku.getLongDescription().equals(longDescription));
        sku.setDescription(description);
        assert (sku.getDescription().equals(description));
        assert (sku.isTaxable() == null);
        sku.setTaxable(null);
        assert (sku.isTaxable() == null);
        sku.setTaxable(Boolean.valueOf(true));
        assert (sku.isTaxable().booleanValue());
        sku.setTaxable(Boolean.valueOf(false));
        assert (!sku.isTaxable().booleanValue());
        sku.setDiscountable(null);
        assert (!sku.isDiscountable().booleanValue());
        sku.setDiscountable(Boolean.valueOf(true));
        assert (sku.isDiscountable().booleanValue());
        sku.setDiscountable(Boolean.valueOf(false));
        assert (!sku.isDiscountable().booleanValue());
        assert (sku.isAvailable().booleanValue());
        sku.setAvailable(null);
        assert (sku.isAvailable().booleanValue());
        sku.setAvailable(Boolean.valueOf(true));
        assert (sku.isAvailable().booleanValue());
        sku.setAvailable(Boolean.valueOf(false));
        assert (!sku.isAvailable().booleanValue());
        assert (sku.getName() == null);
    }
}

