/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.legacy;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.GiftWrapOrderItemRequest;
import org.broadleafcommerce.core.order.service.legacy.LegacyCartService;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.test.legacy.LegacyCommonSetupBaseTest;

public class LegacyOrderBaseTest
extends LegacyCommonSetupBaseTest {
    @Resource(name="blOrderService")
    protected LegacyCartService cartService;
    private int bundleCount = 0;

    protected Customer createNamedCustomer() {
        Customer customer = this.customerService.createCustomerFromId(null);
        customer.setUsername(String.valueOf(customer.getId()));
        return customer;
    }

    public Order setUpNamedOrder() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNamedOrderForCustomer("Boxes Named Order", customer);
        Product newProduct = this.addTestProduct("Cube Box", "Boxes");
        Category newCategory = newProduct.getDefaultCategory();
        this.cartService.addSkuToOrder(order.getId(), newProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        return order;
    }

    public Order setUpAnonymousCartWithInactiveSku() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        Product newProduct = this.addTestProduct("Plastic Crate", "Crates");
        Product newInactiveProduct = this.addTestProduct("Plastic Crate", "Crates", false);
        Category newCategory = newProduct.getDefaultCategory();
        this.cartService.addSkuToOrder(order.getId(), newProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.cartService.addSkuToOrder(order.getId(), newInactiveProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.cartService.addBundleItemToOrder(order, this.createBundleOrderItemRequest());
        this.cartService.addBundleItemToOrder(order, this.createBundleOrderItemRequestWithInactiveSku());
        return order;
    }

    public Order setUpAnonymousCartWithGiftWrap() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        Product newProduct = this.addTestProduct("Plastic Crate", "Crates");
        Product newInactiveProduct = this.addTestProduct("Plastic Crate", "Crates");
        Product giftWrapProduct = this.addTestProduct("Gift Box", "Gift Wraps");
        Category newCategory = newProduct.getDefaultCategory();
        ArrayList<OrderItem> addedItems = new ArrayList<OrderItem>();
        addedItems.add(this.cartService.addSkuToOrder(order.getId(), newProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2)));
        addedItems.add(this.cartService.addSkuToOrder(order.getId(), newInactiveProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2)));
        this.cartService.addGiftWrapItemToOrder(order, this.createGiftWrapOrderItemRequest(giftWrapProduct, giftWrapProduct.getDefaultSku(), 1, addedItems));
        return order;
    }

    public Order setUpAnonymousCartWithInactiveGiftWrap() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        Product newProduct = this.addTestProduct("Plastic Crate", "Crates");
        Product newInactiveProduct = this.addTestProduct("Plastic Crate", "Crates", false);
        Product giftWrapProduct = this.addTestProduct("Gift Box", "Gift Wraps");
        Category newCategory = newProduct.getDefaultCategory();
        ArrayList<OrderItem> addedItems = new ArrayList<OrderItem>();
        addedItems.add(this.cartService.addSkuToOrder(order.getId(), newProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2)));
        addedItems.add(this.cartService.addSkuToOrder(order.getId(), newInactiveProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2)));
        this.cartService.addGiftWrapItemToOrder(order, this.createGiftWrapOrderItemRequest(giftWrapProduct, giftWrapProduct.getDefaultSku(), 1, addedItems));
        return order;
    }

    public Order initializeExistingCartWithInactiveSkuAndInactiveBundle(Customer customer) throws PricingException {
        Product newProduct = this.addTestProduct("Plastic Crate", "Crates");
        Product newInactiveProduct = this.addTestProduct("Plastic Crate", "Crates", false);
        Category newCategory = newProduct.getDefaultCategory();
        Order order = this.cartService.createNewCartForCustomer(customer);
        this.cartService.addSkuToOrder(order.getId(), newProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.cartService.addSkuToOrder(order.getId(), newInactiveProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.cartService.addBundleItemToOrder(order, this.createBundleOrderItemRequest());
        this.cartService.addBundleItemToOrder(order, this.createBundleOrderItemRequestWithInactiveSku());
        return order;
    }

    public Order initializeExistingCart(Customer customer) throws PricingException {
        Product newProduct = this.addTestProduct("Plastic Crate", "Crates");
        Product newOtherProduct = this.addTestProduct("Plastic Crate", "Crates");
        Category newCategory = newProduct.getDefaultCategory();
        Order order = this.cartService.createNewCartForCustomer(customer);
        this.cartService.addSkuToOrder(order.getId(), newProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.cartService.addSkuToOrder(order.getId(), newOtherProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        return order;
    }

    public BundleOrderItemRequest createBundleOrderItemRequest() {
        Product screwProduct = this.addTestProduct("Bookshelf", "Components");
        Product shelfProduct = this.addTestProduct("Bookshelf", "Components");
        Product bracketsProduct = this.addTestProduct("Bookshelf", "Components");
        Category category = screwProduct.getDefaultCategory();
        ArrayList<DiscreteOrderItemRequest> discreteOrderItems = new ArrayList<DiscreteOrderItemRequest>();
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(screwProduct, screwProduct.getDefaultSku(), 20));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(shelfProduct, shelfProduct.getDefaultSku(), 3));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(bracketsProduct, bracketsProduct.getDefaultSku(), 6));
        BundleOrderItemRequest itemRequest = new BundleOrderItemRequest();
        itemRequest.setCategory(category);
        itemRequest.setName("test bundle " + this.bundleCount++);
        itemRequest.setQuantity(1);
        itemRequest.setDiscreteOrderItems(discreteOrderItems);
        return itemRequest;
    }

    public BundleOrderItemRequest createBundleOrderItemRequestWithInactiveSku() {
        Product drawerProduct = this.addTestProduct("Drawer System", "Systems");
        Product nailsProduct = this.addTestProduct("Drawer System", "Systems");
        Product tracksProduct = this.addTestProduct("Drawer System", "Systems", false);
        Category category = drawerProduct.getDefaultCategory();
        ArrayList<DiscreteOrderItemRequest> discreteOrderItems = new ArrayList<DiscreteOrderItemRequest>();
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(drawerProduct, drawerProduct.getDefaultSku(), 20));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(nailsProduct, nailsProduct.getDefaultSku(), 3));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(tracksProduct, tracksProduct.getDefaultSku(), 6));
        BundleOrderItemRequest itemRequest = new BundleOrderItemRequest();
        itemRequest.setCategory(category);
        itemRequest.setName("test bundle " + this.bundleCount++);
        itemRequest.setQuantity(1);
        itemRequest.setDiscreteOrderItems(discreteOrderItems);
        return itemRequest;
    }

    public DiscreteOrderItemRequest createDiscreteOrderItemRequest(Product product, Sku sku, int quantity) {
        DiscreteOrderItemRequest request = new DiscreteOrderItemRequest();
        request.setSku(sku);
        request.setQuantity(quantity);
        request.setProduct(product);
        request.setCategory(product.getDefaultCategory());
        return request;
    }

    public GiftWrapOrderItemRequest createGiftWrapOrderItemRequest(Product product, Sku sku, int quantity, List<OrderItem> wrappedItems) {
        GiftWrapOrderItemRequest request = new GiftWrapOrderItemRequest();
        request.setSku(sku);
        request.setQuantity(quantity);
        request.setProduct(product);
        request.setCategory(product.getDefaultCategory());
        request.setWrappedItems(wrappedItems);
        return request;
    }

    public Order setUpAnonymousCartWithInactiveBundleGiftWrap() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        Product newProduct = this.addTestProduct("Plastic Crate", "Crates");
        Product newInactiveProduct = this.addTestProduct("Plastic Crate", "Crates", false);
        Product giftWrapProduct = this.addTestProduct("Gift Box", "Gift Wraps");
        Category category = newProduct.getDefaultCategory();
        ArrayList<Object> discreteOrderItems = new ArrayList<Object>();
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(newProduct, newProduct.getDefaultSku(), 1));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(newInactiveProduct, newInactiveProduct.getDefaultSku(), 1));
        discreteOrderItems.add(this.createGiftWrapOrderItemRequest(giftWrapProduct, giftWrapProduct.getDefaultSku(), 1, new ArrayList<OrderItem>()));
        BundleOrderItemRequest itemRequest = new BundleOrderItemRequest();
        itemRequest.setCategory(category);
        itemRequest.setName("test bundle " + this.bundleCount++);
        itemRequest.setQuantity(1);
        itemRequest.setDiscreteOrderItems(discreteOrderItems);
        BundleOrderItem newBundle = (BundleOrderItem)this.cartService.addBundleItemToOrder(order, itemRequest);
        ArrayList<DiscreteOrderItem> addedItems = new ArrayList<DiscreteOrderItem>();
        GiftWrapOrderItem giftItem = null;
        for (DiscreteOrderItem addedItem : newBundle.getDiscreteOrderItems()) {
            if (addedItem instanceof GiftWrapOrderItem) {
                giftItem = (GiftWrapOrderItem)addedItem;
                continue;
            }
            addedItems.add(addedItem);
        }
        for (DiscreteOrderItem addedItem : addedItems) {
            addedItem.setGiftWrapOrderItem(giftItem);
        }
        giftItem.getWrappedItems().addAll(addedItems);
        order = this.cartService.save(order, Boolean.valueOf(false));
        return order;
    }

    public Order setUpAnonymousCartWithBundleGiftWrap() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        BundleOrderItemRequest itemRequest = this.createBundleOrderItemRequestWithGiftWrap();
        BundleOrderItem newBundle = (BundleOrderItem)this.cartService.addBundleItemToOrder(order, itemRequest);
        ArrayList<DiscreteOrderItem> addedItems = new ArrayList<DiscreteOrderItem>();
        GiftWrapOrderItem giftItem = null;
        for (DiscreteOrderItem addedItem : newBundle.getDiscreteOrderItems()) {
            if (addedItem instanceof GiftWrapOrderItem) {
                giftItem = (GiftWrapOrderItem)addedItem;
                continue;
            }
            addedItems.add(addedItem);
        }
        for (DiscreteOrderItem addedItem : addedItems) {
            addedItem.setGiftWrapOrderItem(giftItem);
        }
        giftItem.getWrappedItems().addAll(addedItems);
        order = this.cartService.save(order, Boolean.valueOf(false));
        return order;
    }

    protected BundleOrderItemRequest createBundleOrderItemRequestWithGiftWrap() {
        Product newProduct = this.addTestProduct("Plastic Crate", "Crates");
        Product newActiveProduct = this.addTestProduct("Plastic Crate", "Crates");
        Product giftWrapProduct = this.addTestProduct("Gift Box", "Gift Wraps");
        Category category = newProduct.getDefaultCategory();
        ArrayList<Object> discreteOrderItems = new ArrayList<Object>();
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(newProduct, newProduct.getDefaultSku(), 1));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(newActiveProduct, newActiveProduct.getDefaultSku(), 1));
        discreteOrderItems.add(this.createGiftWrapOrderItemRequest(giftWrapProduct, giftWrapProduct.getDefaultSku(), 1, new ArrayList<OrderItem>()));
        BundleOrderItemRequest itemRequest = new BundleOrderItemRequest();
        itemRequest.setCategory(category);
        itemRequest.setName("test bundle " + this.bundleCount++);
        itemRequest.setQuantity(1);
        itemRequest.setDiscreteOrderItems(discreteOrderItems);
        return itemRequest;
    }

    public Order setUpAnonymousCartWithBundleGiftWrapReferringToRootItems() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        Product newProduct = this.addTestProduct("Plastic Bowl", "Bowls");
        Product newActiveProduct = this.addTestProduct("Plastic Bowl", "Bowls");
        Category newCategory = newProduct.getDefaultCategory();
        ArrayList<OrderItem> addedItems = new ArrayList<OrderItem>();
        addedItems.add(this.cartService.addSkuToOrder(order.getId(), newProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2)));
        addedItems.add(this.cartService.addSkuToOrder(order.getId(), newActiveProduct.getDefaultSku().getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2)));
        BundleOrderItem newBundle = (BundleOrderItem)this.cartService.addBundleItemToOrder(order, this.createBundleOrderItemRequestWithGiftWrap());
        GiftWrapOrderItem giftItem = null;
        for (DiscreteOrderItem discreteOrderItem : newBundle.getDiscreteOrderItems()) {
            if (!(discreteOrderItem instanceof GiftWrapOrderItem)) continue;
            giftItem = (GiftWrapOrderItem)discreteOrderItem;
        }
        for (OrderItem orderItem : addedItems) {
            orderItem.setGiftWrapOrderItem(giftItem);
        }
        giftItem.getWrappedItems().addAll(addedItems);
        order = this.cartService.save(order, Boolean.valueOf(false));
        return order;
    }

    public Order setUpAnonymousCartWithBundleGiftWrapReferringItemsInAnotherBundle() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        BundleOrderItem newBundle = (BundleOrderItem)this.cartService.addBundleItemToOrder(order, this.createBundleOrderItemRequest());
        BundleOrderItem newBundle2 = (BundleOrderItem)this.cartService.addBundleItemToOrder(order, this.createBundleOrderItemRequestWithGiftWrap());
        GiftWrapOrderItem giftItem = null;
        for (DiscreteOrderItem addedItem : newBundle2.getDiscreteOrderItems()) {
            if (!(addedItem instanceof GiftWrapOrderItem)) continue;
            giftItem = (GiftWrapOrderItem)addedItem;
        }
        for (DiscreteOrderItem addedItem : newBundle.getDiscreteOrderItems()) {
            addedItem.setGiftWrapOrderItem(giftItem);
        }
        giftItem.getWrappedItems().addAll(newBundle.getDiscreteOrderItems());
        order = this.cartService.save(order, Boolean.valueOf(false));
        return order;
    }
}

