/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXrefImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.test.BaseTest;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.testng.annotations.Test;

public class MVELTest
extends BaseTest {
    private StringBuffer functions = new StringBuffer();

    public MVELTest() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/broadleafcommerce/core/offer/service/mvelFunctions.mvel");
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                this.functions.append(line);
            }
            this.functions.append(" ");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
            }
        }
    }

    @Test
    public void testOfferAppliesToItemsInCategoryAndOrderValueGreaterThanFifty() {
        OrderImpl order = new OrderImpl();
        CategoryImpl category = new CategoryImpl();
        category.setName("t-shirt");
        DiscreteOrderItemImpl orderItem = new DiscreteOrderItemImpl();
        ProductImpl product = new ProductImpl();
        ArrayList<CategoryProductXrefImpl> categories = new ArrayList<CategoryProductXrefImpl>();
        CategoryProductXrefImpl categoryXref = new CategoryProductXrefImpl();
        categoryXref.setProduct((Product)product);
        categoryXref.setCategory((Category)category);
        categories.add(categoryXref);
        product.setAllParentCategoryXrefs(categories);
        orderItem.setProduct((Product)product);
        order.getOrderItems().add(orderItem);
        order.setSubTotal(new Money(110.0));
        ParserContext context = new ParserContext();
        context.addImport("OfferType", OfferType.class);
        Serializable domainExp1 = MVEL.compileExpression((String)"result = false; for (cat : currentItem.product.allParentCategories) {if (cat.name == 't-shirt') {result = true;}}; return result and order.subTotal.amount >= 50", (ParserContext)context);
        HashMap<String, Object> domainVars = new HashMap<String, Object>();
        domainVars.put("order", order);
        domainVars.put("currentItem", orderItem);
        Boolean expressionOutcome1 = (Boolean)MVEL.executeExpression((Object)domainExp1, domainVars);
        assert (expressionOutcome1 != null && expressionOutcome1.booleanValue());
        Serializable domainExp2 = MVEL.compileExpression((String)"($ in currentItem.product.allParentCategories if $.name == 't-shirt') != empty and order.subTotal.amount >= 50", (ParserContext)context);
        Boolean expressionOutcome2 = (Boolean)MVEL.executeExpression((Object)domainExp2, domainVars);
        assert (expressionOutcome2 != null && expressionOutcome2.booleanValue());
    }

    @Test
    public void testBasicMVELFunctions() {
        HashMap functionMap = new HashMap();
        StringBuffer functions = new StringBuffer("def any(x, y) { return x or y } def all(x, y) { return x and y } ");
        MVEL.eval((String)functions.toString(), functionMap);
        HashMap<String, String> vars = new HashMap<String, String>(functionMap);
        vars.put("fg", "Hello");
        StringBuffer expression = new StringBuffer();
        expression.append("return all(fg == 'Hello', true)");
        Boolean result = (Boolean)MVEL.eval((String)expression.toString(), vars);
        assert (result != null && result.booleanValue());
        expression = new StringBuffer();
        expression.append("return any(fg == 'Goodbye', false)");
        Boolean result2 = (Boolean)MVEL.eval((String)expression.toString(), vars);
        assert (result2 != null && !result2.booleanValue());
    }

    @Test
    public void testOfferAppliesToSpecificItems() {
        DiscreteOrderItemImpl orderItem = new DiscreteOrderItemImpl();
        SkuImpl sku = new SkuImpl();
        sku.setRetailPrice(new Money("1"));
        sku.setId(Long.valueOf(1234L));
        orderItem.setSku((Sku)sku);
        OfferImpl offer = new OfferImpl();
        offer.setType(OfferType.ORDER_ITEM);
        ParserContext context = new ParserContext();
        context.addImport("OfferType", OfferType.class);
        context.addImport("FulfillmentType", FulfillmentType.class);
        Serializable domainExp1 = MVEL.compileExpression((String)"offer.type == OfferType.ORDER_ITEM and (currentItem.sku.id in [1234, 2345, 5678])", (ParserContext)context);
        HashMap<String, Object> domainVars = new HashMap<String, Object>();
        domainVars.put("currentItem", orderItem);
        domainVars.put("offer", offer);
        Boolean expressionOutcome1 = (Boolean)MVEL.executeExpression((Object)domainExp1, domainVars);
        assert (expressionOutcome1 != null && expressionOutcome1.booleanValue());
    }

    public void testOfferAppliesToHatsWhenOneLawnmowerIsPurchased() {
        OrderImpl order = new OrderImpl();
        ArrayList<DiscreteOrderItemImpl> items = new ArrayList<DiscreteOrderItemImpl>();
        order.setOrderItems(items);
        DiscreteOrderItemImpl item = new DiscreteOrderItemImpl();
        Money amount = new Money(10.0);
        items.add(item);
        item.setSalePrice(amount);
        ProductImpl product = new ProductImpl();
        CategoryImpl category = new CategoryImpl();
        category.setName("hat");
        product.setDefaultCategory((Category)category);
        item.setProduct((Product)product);
        item.setQuantity(3);
        DiscreteOrderItemImpl item2 = new DiscreteOrderItemImpl();
        Money amount2 = new Money(250.0);
        items.add(item2);
        item2.setSalePrice(amount2);
        ProductImpl product2 = new ProductImpl();
        CategoryImpl category2 = new CategoryImpl();
        category2.setName("lawnmower");
        product2.setDefaultCategory((Category)category2);
        item2.setProduct((Product)product2);
        item2.setQuantity(1);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("currentItem", item);
        vars.put("order", order);
        vars.put("doMark", false);
        StringBuffer expression = new StringBuffer(this.functions);
        expression.append("def evalItemForOrderContains(item) {").append("             return item.product.defaultCategory.name == 'lawnmower'").append("          } ").append("          return (orderContainsPlusMark(1) and currentItem.product.defaultCategory.name == 'hat');");
        Boolean result = (Boolean)MVEL.eval((String)expression.toString(), vars);
        assert (result != null && result.booleanValue());
    }

    @Test
    public void testOfferAppliesToFulfillmentGroup() {
        OrderImpl order = new OrderImpl();
        order.setSubTotal(new Money(110.0));
        FulfillmentGroupImpl group = new FulfillmentGroupImpl();
        group.setPrimary(true);
        OfferImpl offer = new OfferImpl();
        offer.setType(OfferType.FULFILLMENT_GROUP);
        order.getFulfillmentGroups().add(group);
        ParserContext context = new ParserContext();
        context.addImport("OfferType", OfferType.class);
        context.addImport("FulfillmentType", FulfillmentType.class);
        Serializable domainExp1 = MVEL.compileExpression((String)"offer.type.equals(OfferType.FULFILLMENT_GROUP) and (($ in order.fulfillmentGroups if $.type.equals(FulfillmentType.PHYSICAL)) != empty)", (ParserContext)context);
        HashMap<String, Object> domainVars = new HashMap<String, Object>();
        domainVars.put("order", order);
        domainVars.put("offer", offer);
        Boolean expressionOutcome1 = (Boolean)MVEL.executeExpression((Object)domainExp1, domainVars);
        assert (expressionOutcome1 != null && expressionOutcome1.booleanValue());
    }
}

