/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.legacy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.SkuDaoDataProvider;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.core.offer.dao.OfferCodeDao;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CustomerOffer;
import org.broadleafcommerce.core.offer.domain.CustomerOfferImpl;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferInfo;
import org.broadleafcommerce.core.offer.service.CreateOfferUtility;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.type.OfferDeliveryType;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.pricing.service.workflow.type.ShippingServiceType;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CountryImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.domain.StateImpl;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.broadleafcommerce.test.legacy.LegacyCommonSetupBaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class LegacyOfferTest
extends LegacyCommonSetupBaseTest {
    @Resource
    private OfferService offerService;
    @Resource
    private CustomerService customerService;
    @Resource(name="blOrderService")
    private OrderService orderService;
    @Resource
    private OfferDao offerDao;
    @Resource
    private CustomerOfferDao customerOfferDao;
    @Resource
    private CatalogService catalogService;
    @Resource
    private OfferCodeDao offerCodeDao;
    @Resource(name="blOrderItemService")
    private OrderItemService orderItemService;
    @Resource
    private CountryService countryService;
    @Resource
    private StateService stateService;
    private long sku1;
    private long sku2;
    private CreateOfferUtility createOfferUtility;

    @Test(groups={"offerCreateSku1Legacy"}, dataProvider="basicSku", dataProviderClass=SkuDaoDataProvider.class)
    @Rollback(value=false)
    public void createSku1(Sku sku) {
        this.createOfferUtility = new CreateOfferUtility(this.offerDao, this.offerCodeDao, this.offerService);
        sku.setSalePrice(new Money(BigDecimal.valueOf(10.0)));
        sku.setRetailPrice(new Money(BigDecimal.valueOf(15.0)));
        sku.setName("test1");
        assert (sku.getId() == null);
        sku = this.catalogService.saveSku(sku);
        assert (sku.getId() != null);
        this.sku1 = sku.getId();
    }

    @Test(groups={"offerCreateSku2Legacy"}, dataProvider="basicSku", dataProviderClass=SkuDaoDataProvider.class)
    @Rollback(value=false)
    public void createSku2(Sku sku) {
        sku.setSalePrice(new Money(BigDecimal.valueOf(10.0)));
        sku.setRetailPrice(new Money(BigDecimal.valueOf(15.0)));
        sku.setName("test2");
        assert (sku.getId() == null);
        sku = this.catalogService.saveSku(sku);
        assert (sku.getId() != null);
        this.sku2 = sku.getId();
    }

    @Test(groups={"testPercentageOffOfferLegacy"}, dependsOnGroups={"offerCreateSku1Legacy", "offerCreateSku2Legacy"})
    @Transactional
    public void testPercentOffOfferWithScaleGreaterThanTwo() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.setFulfillmentGroups(this.createFulfillmentGroups("standard", ShippingServiceType.BANDED_SHIPPING.getType(), 5.0, order));
        this.orderService.save(order, Boolean.valueOf(false));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 100.0, null, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 100.0, null, true, 1, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20.5 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.5, null, null, true, true, 10));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().equals((Object)new Money(238.5)));
    }

    @Test(groups={"offerUsedForPricingLegacy"}, dependsOnGroups={"offerCreateSku1Legacy", "offerCreateSku2Legacy"})
    @Transactional
    public void testOfferUsedForPricing() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 10.0, null, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 20.0, null, true, 1, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id == " + this.sku1, true, true, 10));
        order.addOfferCode(this.createOfferUtility.createOfferCode("3 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 3.0, null, "discreteOrderItem.sku.id != " + this.sku1, true, true, 10));
        order.addOfferCode(this.createOfferUtility.createOfferCode("1.20 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 1.2, null, null, true, true, 10));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(31.8)));
    }

    @Test(groups={"testOfferNotStackableItemOffersLegacy"}, dependsOnGroups={"offerUsedForPricingLegacy"})
    @Transactional
    public void testOfferNotStackableItemOffers() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 100.0, null, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 100.0, null, true, 2, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id == " + this.sku1, false, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("30 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 30.0, null, "discreteOrderItem.sku.id == " + this.sku1, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id != " + this.sku1, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("30 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 30.0, null, "discreteOrderItem.sku.id != " + this.sku1, false, true, 1));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().equals((Object)new Money(252.0)));
    }

    @Test(groups={"testOfferNotCombinableItemOffersLegacy"}, dependsOnGroups={"testOfferNotStackableItemOffersLegacy"})
    @Transactional
    public void testOfferNotCombinableItemOffers() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 100.0, null, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 100.0, null, true, 2, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id == " + this.sku1, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("30 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 30.0, null, "discreteOrderItem.sku.id == " + this.sku1, true, false, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id != " + this.sku1, true, false, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("30 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 30.0, null, "discreteOrderItem.sku.id != " + this.sku1, true, true, 1));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().equals((Object)new Money(280.0)));
    }

    @Test(groups={"testOfferLowerSalePriceLegacy"})
    @Transactional
    public void testOfferLowerSalePrice() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 100.0, 50.0, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 100.0, null, true, 2, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id == " + this.sku1, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("30 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 30.0, null, "discreteOrderItem.sku.id == " + this.sku1, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id != " + this.sku1, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("30 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 30.0, null, "discreteOrderItem.sku.id != " + this.sku1, true, true, 1));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().equals((Object)new Money(212.0)));
    }

    @Test(groups={"testOfferLowerSalePriceWithNotCombinableOfferLegacy"})
    @Transactional
    public void testOfferLowerSalePriceWithNotCombinableOffer() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 100.0, 50.0, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 100.0, null, true, 2, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, null, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("30 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 30.0, null, null, true, false, 1));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().equals((Object)new Money(240.0)));
    }

    @Test(groups={"testOfferLowerSalePriceWithNotCombinableOfferAndInformationLegacy"})
    @Transactional
    public void testOfferLowerSalePriceWithNotCombinableOfferAndInformation() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 100.0, 50.0, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 100.0, null, true, 2, order));
        OfferCode offerCode1 = this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, null, true, true, 1);
        OfferCode offerCode2 = this.createOfferUtility.createOfferCode("30 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 30.0, null, null, true, false, 1);
        order.addOfferCode(offerCode1);
        order.addOfferCode(offerCode2);
        order = this.orderService.save(order, Boolean.valueOf(false));
        OfferInfo info1 = this.offerDao.createOfferInfo();
        info1.getFieldValues().put("key1", "value1");
        order.getAdditionalOfferInformation().put(offerCode1.getOffer(), info1);
        OfferInfo info2 = this.offerDao.createOfferInfo();
        info2.getFieldValues().put("key2", "value2");
        order.getAdditionalOfferInformation().put(offerCode2.getOffer(), info2);
        order = this.orderService.save(order, Boolean.valueOf(false));
        order = this.orderService.save(order, Boolean.valueOf(true));
        assert (order.getSubTotal().equals((Object)new Money(240.0)));
        order = this.orderService.findOrderById(order.getId());
        assert (((OfferInfo)order.getAdditionalOfferInformation().get(offerCode1.getOffer())).equals(info1));
    }

    @Test(groups={"testOfferLowerSalePriceWithNotCombinableOffer2Legacy"})
    @Transactional
    public void testOfferLowerSalePriceWithNotCombinableOffer2() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 100.0, 50.0, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 100.0, 50.0, true, 2, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("25 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 25.0, null, null, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("35 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 35.0, null, null, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("45 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 45.0, null, null, true, false, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("30 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 30.0, null, null, true, true, 1));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(130.0)));
    }

    @Test(groups={"testOfferNotCombinableOrderOffersLegacy"})
    @Transactional
    public void testOfferNotCombinableOrderOffers() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 100.0, null, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 100.0, null, true, 2, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Order Offer", OfferType.ORDER, OfferDiscountType.PERCENT_OFF, 20.0, null, null, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("30 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 30.0, null, null, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("50 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 50.0, null, null, true, false, 1));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(290.0)));
    }

    @Test(groups={"testOfferNotCombinableOrderOffersWithItemOfferLegacy"})
    @Transactional
    public void testOfferNotCombinableOrderOffersWithItemOffer() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 100.0, null, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 100.0, null, true, 2, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, null, true, false, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("10 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 10.0, null, null, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("15 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 15.0, null, null, true, true, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("90 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 90.0, null, null, true, false, 1));
        order.addOfferCode(this.createOfferUtility.createOfferCode("50 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 50.0, null, null, true, true, 1));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(210.0)));
    }

    @Test(groups={"testGlobalOffersLegacy"})
    @Transactional
    public void testGlobalOffers() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 10.0, null, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 20.0, null, true, 1, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id == " + this.sku1, true, true, 10));
        order.addOfferCode(this.createOfferUtility.createOfferCode("3 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 3.0, null, "discreteOrderItem.sku.id != " + this.sku1, true, true, 10));
        Offer offer = this.createOfferUtility.createOffer("1.20 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 1.2, null, null, true, true, 10);
        offer.setDeliveryType(OfferDeliveryType.AUTOMATIC);
        offer.setAutomaticallyAdded(true);
        offer = this.offerService.save(offer);
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(31.8)));
    }

    @Test(groups={"testCustomerAssociatedOffersLegacy"})
    @Transactional
    public void testCustomerAssociatedOffers() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 10.0, null, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 20.0, null, true, 1, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id == " + this.sku1, true, true, 10));
        order.addOfferCode(this.createOfferUtility.createOfferCode("3 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 3.0, null, "discreteOrderItem.sku.id != " + this.sku1, true, true, 10));
        Offer offer = this.createOfferUtility.createOffer("1.20 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 1.2, null, null, true, true, 10);
        offer.setDeliveryType(OfferDeliveryType.MANUAL);
        offer = this.offerService.save(offer);
        CustomerOfferImpl customerOffer = new CustomerOfferImpl();
        customerOffer.setCustomer(order.getCustomer());
        customerOffer.setOffer(offer);
        customerOffer = this.customerOfferDao.save((CustomerOffer)customerOffer);
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(31.8)));
    }

    @Test(groups={"testCustomerAssociatedOffers2Legacy"})
    @Transactional
    public void testCustomerAssociatedOffers2() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 20.0, null, true, 1, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 20.0, null, true, 1, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("15%OFF", "15 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 15.0, null, null, false, true, 0));
        Offer offer1 = this.createOfferUtility.createOffer("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.id == " + this.sku1, false, true, 0);
        offer1.setDeliveryType(OfferDeliveryType.MANUAL);
        this.offerDao.save(offer1);
        CustomerOfferImpl customerOffer1 = new CustomerOfferImpl();
        customerOffer1.setCustomer(order.getCustomer());
        customerOffer1.setOffer(offer1);
        this.customerOfferDao.save((CustomerOffer)customerOffer1);
        Offer offer2 = this.createOfferUtility.createOffer("10 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 10.0, null, "discreteOrderItem.sku.id == " + this.sku2, false, true, 0);
        offer2.setDeliveryType(OfferDeliveryType.MANUAL);
        this.offerDao.save(offer2);
        CustomerOfferImpl customerOffer2 = new CustomerOfferImpl();
        customerOffer2.setCustomer(order.getCustomer());
        customerOffer2.setOffer(offer2);
        this.customerOfferDao.save((CustomerOffer)customerOffer2);
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        assert (order.getSubTotal().equals((Object)new Money(33.0)));
    }

    @Test(groups={"testFulfillmentGroupOffersLegacy"})
    @Transactional
    public void testFulfillmentGroupOffers() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        order.setFulfillmentGroups(this.createFulfillmentGroups("standard", ShippingServiceType.BANDED_SHIPPING.getType(), 5.0, order));
        this.orderService.save(order, Boolean.valueOf(false));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku1, 10.0, null, true, 2, order));
        order.addOrderItem((OrderItem)this.createDiscreteOrderItem(this.sku2, 20.0, null, true, 1, order));
        order.addOfferCode(this.createOfferUtility.createOfferCode("20 Percent Off Item Offer", OfferType.FULFILLMENT_GROUP, OfferDiscountType.PERCENT_OFF, 20.0, null, null, true, true, 10));
        order.addOfferCode(this.createOfferUtility.createOfferCode("3 Dollars Off Item Offer", OfferType.FULFILLMENT_GROUP, OfferDiscountType.AMOUNT_OFF, 3.0, null, null, true, true, 10));
        List offers = this.offerService.buildOfferListForOrder(order);
        this.offerService.applyOffersToOrder(offers, order);
        this.offerService.applyFulfillmentGroupOffersToOrder(offers, order);
        assert (((FulfillmentGroup)order.getFulfillmentGroups().get(0)).getShippingPrice().equals((Object)new Money(1.6)));
    }

    @Test(groups={"testOfferDeleteLegacy"})
    @Transactional
    public void testOfferDelete() throws Exception {
        CustomerOffer customerOffer = this.customerOfferDao.create();
        Customer customer = this.createCustomer();
        Long customerId = customer.getId();
        customerOffer.setCustomer(this.customerService.saveCustomer(customer));
        Offer offer = this.createOfferUtility.createOffer("1.20 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 1.2, null, null, true, true, 10);
        offer = this.offerService.save(offer);
        Long offerId = offer.getId();
        this.offerDao.delete(offer);
        Offer deletedOffer = this.offerDao.readOfferById(offerId);
        assert (((OfferImpl)deletedOffer).getArchived().charValue() == 'Y');
        offer = this.createOfferUtility.createOffer("1.20 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 1.2, null, null, true, true, 10);
        offer = this.offerService.save(offer);
        customerOffer.setOffer(offer);
        customerOffer = this.customerOfferDao.save(customerOffer);
        Long customerOfferId = customerOffer.getId();
        customerOffer = this.customerOfferDao.readCustomerOfferById(customerOfferId);
        assert (customerOffer != null);
        Customer customer2 = this.createCustomer();
        customerOffer.setCustomer(this.customerService.saveCustomer(customer2));
        customerOffer = this.customerOfferDao.save(customerOffer);
        assert (!customerOffer.getCustomer().getId().equals(customerId));
        this.customerOfferDao.delete(customerOffer);
        customerOffer = this.customerOfferDao.readCustomerOfferById(customerOfferId);
        assert (customerOffer == null || ((OfferImpl)customerOffer).getArchived().charValue() == 'Y');
    }

    @Test(groups={"testReadAllOffersLegacy"})
    @Transactional
    public void testReadAllOffers() throws Exception {
        Offer offer = this.createOfferUtility.createOffer("1.20 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 1.2, null, null, true, true, 10);
        offer.setDeliveryType(OfferDeliveryType.MANUAL);
        offer = this.offerService.save(offer);
        List allOffers = this.offerService.findAllOffers();
        assert (allOffers != null && !allOffers.isEmpty());
    }

    @Test(groups={"testOfferCodeDaoLegacy"})
    @Transactional
    public void testOfferCodeDao() throws Exception {
        String offerCodeString = "AJ's Code";
        OfferCode offerCode = this.createOfferUtility.createOfferCode("1.20 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 1.2, null, null, true, true, 10);
        offerCode.setOfferCode(offerCodeString);
        offerCode = this.offerService.saveOfferCode(offerCode);
        Long offerCodeId = offerCode.getId();
        assert (offerCode.getOfferCode().equals(offerCodeString));
        Offer offer = offerCode.getOffer();
        Offer storedOffer = this.offerService.lookupOfferByCode(offerCodeString);
        assert (offer.getId().equals(storedOffer.getId()));
        OfferCode newOfferCode = this.offerCodeDao.readOfferCodeById(offerCodeId);
        assert (newOfferCode.getOfferCode().equals(offerCode.getOfferCode()));
        newOfferCode = this.offerCodeDao.readOfferCodeByCode(offerCodeString);
        assert (newOfferCode.getOfferCode().equals(offerCode.getOfferCode()));
        offerCodeId = newOfferCode.getId();
        this.offerCodeDao.delete(newOfferCode);
        OfferCode deletedOfferCode = this.offerCodeDao.readOfferCodeById(offerCodeId);
        assert (deletedOfferCode == null);
    }

    @Test(groups={"testCustomerOffersLegacy"})
    @Transactional
    public void testCustomerOffers() throws Exception {
        Order order = this.orderService.createNewCartForCustomer(this.createCustomer());
        Offer offer = this.createOfferUtility.createOffer("1.20 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 1.2, null, null, true, true, 10);
        CustomerOfferImpl customerOffer = new CustomerOfferImpl();
        customerOffer.setCustomer(order.getCustomer());
        customerOffer.setOffer(offer);
        customerOffer = this.customerOfferDao.save((CustomerOffer)customerOffer);
        CustomerOffer customerOfferTest = this.customerOfferDao.readCustomerOfferById(customerOffer.getId());
        assert (customerOffer.getId().equals(customerOfferTest.getId()));
    }

    private List<FulfillmentGroup> createFulfillmentGroups(String method, String service, Double shippingPrice, Order order) {
        ArrayList<FulfillmentGroup> groups = new ArrayList<FulfillmentGroup>();
        FulfillmentGroupImpl group = new FulfillmentGroupImpl();
        group.setMethod(method);
        group.setService(service);
        groups.add((FulfillmentGroup)group);
        group.setRetailShippingPrice(new Money(shippingPrice.doubleValue()));
        group.setOrder(order);
        AddressImpl address = new AddressImpl();
        address.setAddressLine1("123 Test Rd");
        address.setCity("Dallas");
        address.setFirstName("Jeff");
        address.setLastName("Fischer");
        address.setPostalCode("75240");
        address.setPrimaryPhone("972-978-9067");
        CountryImpl country = new CountryImpl();
        country.setAbbreviation("US");
        country.setName("United States");
        this.countryService.save((Country)country);
        StateImpl state = new StateImpl();
        state.setAbbreviation("TX");
        state.setName("Texas");
        state.setCountry((Country)country);
        this.stateService.save((State)state);
        address.setState((State)state);
        address.setCountry((Country)country);
        for (OrderItem orderItem : order.getOrderItems()) {
            FulfillmentGroupItemImpl fgItem = new FulfillmentGroupItemImpl();
            fgItem.setFulfillmentGroup((FulfillmentGroup)group);
            fgItem.setOrderItem(orderItem);
            fgItem.setQuantity(orderItem.getQuantity());
            group.addFulfillmentGroupItem((FulfillmentGroupItem)fgItem);
        }
        group.setAddress((Address)address);
        return groups;
    }

    private DiscreteOrderItem createDiscreteOrderItem(Long skuId, Double retailPrice, Double salePrice, boolean isDiscountable, int quantity, Order order) {
        DiscreteOrderItemImpl item = new DiscreteOrderItemImpl();
        Sku sku = this.catalogService.findSkuById(skuId);
        sku.setRetailPrice(new Money(retailPrice.doubleValue()));
        if (salePrice != null) {
            sku.setSalePrice(new Money(salePrice.doubleValue()));
        } else {
            sku.setSalePrice(null);
        }
        sku.setDiscountable(Boolean.valueOf(isDiscountable));
        sku.setName("test");
        sku = this.catalogService.saveSku(sku);
        item.setSku(sku);
        item.setQuantity(quantity);
        ProductImpl product = new ProductImpl();
        product.setDefaultSku(sku);
        product = this.catalogService.saveProduct((Product)product);
        item.setProduct((Product)product);
        item.setOrder(order);
        item = (DiscreteOrderItem)this.orderItemService.saveOrderItem((OrderItem)item);
        return item;
    }
}

