/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.ProductDataProvider;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.CrossSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.UpSaleProductImpl;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class ProductDaoTest
extends BaseTest {
    @Resource
    private ProductDao productDao;
    @Resource
    private CatalogService catalogService;
    private List<Product> savedProducts = new ArrayList<Product>();

    private static RelatedProduct getRelatedUpSaleProduct(Product prod, Product prodToRelate, List<RelatedProduct> upSales) {
        UpSaleProductImpl rp1 = new UpSaleProductImpl();
        rp1.setProduct(prod);
        rp1.setPromotionMessage("brand new coffee");
        rp1.setRelatedProduct(prodToRelate);
        upSales.add((RelatedProduct)rp1);
        return rp1;
    }

    private static RelatedProduct getRelatedCrossProduct(Product prod, Product prodToRelate, List<RelatedProduct> upSales) {
        CrossSaleProductImpl rp1 = new CrossSaleProductImpl();
        rp1.setProduct(prod);
        rp1.setPromotionMessage("brand new coffee");
        rp1.setRelatedProduct(prodToRelate);
        upSales.add((RelatedProduct)rp1);
        return rp1;
    }

    @Test(groups={"createProducts"}, dataProvider="setupProducts", dataProviderClass=ProductDataProvider.class)
    @Rollback(value=false)
    @Transactional
    public void createProducts(Product product) {
        product = this.catalogService.saveProduct(product);
        assert (product.getId() != null);
        this.savedProducts.add(product);
    }

    @Test(groups={"createUpSaleValues"}, dependsOnGroups={"createProducts"})
    @Rollback(value=false)
    @Transactional
    public void createUpSaleValues() {
        Product prod1 = this.savedProducts.get(0);
        ArrayList<RelatedProduct> upSales = new ArrayList<RelatedProduct>();
        ProductDaoTest.getRelatedUpSaleProduct(prod1, this.savedProducts.get(2), upSales);
        ProductDaoTest.getRelatedUpSaleProduct(prod1, this.savedProducts.get(3), upSales);
        ProductDaoTest.getRelatedUpSaleProduct(prod1, this.savedProducts.get(4), upSales);
        prod1.setUpSaleProducts(upSales);
        prod1 = this.catalogService.saveProduct(prod1);
        assert (prod1.getId() != null);
        Product prod2 = this.savedProducts.get(1);
        ArrayList<RelatedProduct> upSales2 = new ArrayList<RelatedProduct>();
        ProductDaoTest.getRelatedUpSaleProduct(prod2, this.savedProducts.get(5), upSales2);
        ProductDaoTest.getRelatedUpSaleProduct(prod2, this.savedProducts.get(6), upSales2);
        prod2.setUpSaleProducts(upSales2);
        prod2 = this.catalogService.saveProduct(prod2);
        assert (prod2.getId() != null);
    }

    @Test(groups={"testReadProductsWithUpSaleValues"}, dependsOnGroups={"createUpSaleValues"})
    @Transactional
    public void testReadProductsWithUpSaleValues() {
        Product result = this.productDao.readProductById(this.savedProducts.get(0).getId());
        List related = result.getUpSaleProducts();
        assert (related != null);
        assert (!related.isEmpty());
        assert (related.size() == 2 || related.size() == 3);
        for (RelatedProduct rp : related) {
            assert (rp instanceof UpSaleProductImpl);
        }
    }

    @Test(groups={"createCrossSaleValues"}, dependsOnGroups={"testReadProductsWithUpSaleValues"})
    @Rollback(value=false)
    @Transactional
    public void createCrossSaleValues() {
        Product prod1 = this.savedProducts.get(0);
        ArrayList<RelatedProduct> crossSale = new ArrayList<RelatedProduct>();
        ProductDaoTest.getRelatedCrossProduct(prod1, this.savedProducts.get(2), crossSale);
        ProductDaoTest.getRelatedCrossProduct(prod1, this.savedProducts.get(3), crossSale);
        ProductDaoTest.getRelatedCrossProduct(prod1, this.savedProducts.get(4), crossSale);
        prod1.setCrossSaleProducts(crossSale);
        prod1 = this.catalogService.saveProduct(prod1);
        assert (prod1.getId() != null);
        Product prod2 = this.savedProducts.get(1);
        ArrayList<RelatedProduct> crossSale2 = new ArrayList<RelatedProduct>();
        ProductDaoTest.getRelatedCrossProduct(prod2, this.savedProducts.get(5), crossSale2);
        ProductDaoTest.getRelatedCrossProduct(prod2, this.savedProducts.get(6), crossSale2);
        prod2.setCrossSaleProducts(crossSale2);
        prod2 = this.catalogService.saveProduct(prod2);
        assert (prod2.getId() != null);
    }

    @Test(groups={"testReadProductsWithCrossSaleValues"}, dependsOnGroups={"createCrossSaleValues"})
    @Transactional
    public void testReadProductsWithCrossSaleValues() {
        Product result = this.productDao.readProductById(this.savedProducts.get(1).getId());
        List related = result.getCrossSaleProducts();
        assert (related != null);
        assert (!related.isEmpty());
        assert (related.size() == 2 || related.size() == 3);
        for (RelatedProduct rp : related) {
            assert (rp instanceof CrossSaleProductImpl);
        }
    }

    @Test(dataProvider="basicProduct", dataProviderClass=ProductDataProvider.class)
    @Transactional
    public void testReadProductsById(Product product) {
        product = this.catalogService.saveProduct(product);
        Product result = this.productDao.readProductById(product.getId());
        assert (product.equals(result));
    }

    @Test(dataProvider="basicProduct", dataProviderClass=ProductDataProvider.class)
    @Transactional
    public void testReadProductsByName(Product product) {
        String name = product.getName();
        product = this.catalogService.saveProduct(product);
        List result = this.productDao.readProductsByName(name);
        assert (result.contains(product));
    }

    @Test(dataProvider="basicProduct", dataProviderClass=ProductDataProvider.class)
    @Transactional
    public void testFeaturedProduct(Product product) {
        product = this.catalogService.saveProduct(product);
        Long productId = product.getId();
        product.setFeaturedProduct(true);
        this.catalogService.saveProduct(product);
        Product testProduct = this.productDao.readProductById(productId);
        assert (testProduct.isFeaturedProduct());
    }
}

