/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.test.CommonSetupBaseTest;

public class OrderBaseTest
extends CommonSetupBaseTest {
    protected Customer createNamedCustomer() {
        Customer customer = this.customerService.createCustomerFromId(null);
        customer.setUsername(String.valueOf(customer.getId()));
        return customer;
    }

    public Order setUpNamedOrder() throws AddToCartException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.orderService.createNamedOrderForCustomer("Boxes Named Order", customer);
        Product newProduct = this.addTestProduct("Cube Box", "Boxes");
        Category newCategory = newProduct.getDefaultCategory();
        order = this.orderService.addItem(order.getId(), new OrderItemRequestDTO(newProduct.getId(), newProduct.getDefaultSku().getId(), newCategory.getId(), Integer.valueOf(2)), true);
        return order;
    }
}

