/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderBaseTest;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class CartTest
extends OrderBaseTest {
    protected boolean cartContainsOnlyTheseItems(Order cart, List<OrderItem> orderItems) {
        ArrayList cartOrderItems = new ArrayList(cart.getOrderItems());
        block0: for (OrderItem item : orderItems) {
            ListIterator it = cartOrderItems.listIterator();
            while (it.hasNext()) {
                OrderItem otherItem = (OrderItem)it.next();
                if (!this.orderItemsSemanticallyEqual((DiscreteOrderItem)item, (DiscreteOrderItem)otherItem)) continue;
                it.remove();
                continue block0;
            }
        }
        return cartOrderItems.size() == 0;
    }

    protected boolean orderItemsSemanticallyEqual(DiscreteOrderItem one, DiscreteOrderItem two) {
        if (one == null && two != null || one != null && two == null) {
            return false;
        }
        if (!one.getClass().equals(two.getClass())) {
            return false;
        }
        if (!one.getSku().getId().equals(two.getSku().getId())) {
            return false;
        }
        if (one.getQuantity() != two.getQuantity()) {
            return false;
        }
        if ((one.getProduct() == null && two.getProduct() != null || one.getProduct() != null && two.getProduct() == null) && !one.getProduct().getId().equals(two.getProduct().getId())) {
            return false;
        }
        return (one.getCategory() != null || two.getCategory() == null) && (one.getCategory() == null || two.getCategory() != null) || one.getCategory().getId().equals(two.getCategory().getId());
    }

    @Test(groups={"testCartAndNamedOrder"})
    @Transactional
    public void testMoveAllItemsToCartFromNamedOrder() throws RemoveFromCartException, AddToCartException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList<OrderItem> namedOrderItems = new ArrayList<OrderItem>();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        Order cart = this.orderService.createNewCartForCustomer(namedOrder.getCustomer());
        cart = this.orderService.addAllItemsFromNamedOrder(namedOrder, true);
        assert (this.cartContainsOnlyTheseItems(cart, namedOrderItems));
        assert (namedOrder.getOrderItems().size() == 0);
    }

    @Test(groups={"testCartAndNamedOrder"})
    @Transactional
    public void testAddAllItemsToCartFromNamedOrder() throws RemoveFromCartException, AddToCartException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList<OrderItem> namedOrderItems = new ArrayList<OrderItem>();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        Order cart = this.orderService.createNewCartForCustomer(namedOrder.getCustomer());
        this.orderService.setMoveNamedOrderItems(false);
        cart = this.orderService.addAllItemsFromNamedOrder(namedOrder, true);
        this.orderService.setMoveNamedOrderItems(true);
        assert (this.cartContainsOnlyTheseItems(cart, namedOrderItems));
    }

    @Test(groups={"testCartAndNamedOrder"})
    @Transactional
    public void testAddAllItemsToCartFromNamedOrderWithoutExistingCart() throws RemoveFromCartException, AddToCartException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList<OrderItem> namedOrderItems = new ArrayList<OrderItem>();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        this.orderService.setMoveNamedOrderItems(false);
        Order cart = this.orderService.addAllItemsFromNamedOrder(namedOrder, true);
        this.orderService.setMoveNamedOrderItems(true);
        assert (this.cartContainsOnlyTheseItems(cart, namedOrderItems));
    }

    @Test(groups={"testCartAndNamedOrder"})
    @Transactional
    public void testAddItemToCartFromNamedOrder() throws RemoveFromCartException, AddToCartException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        ArrayList<OrderItem> movedOrderItems = new ArrayList<OrderItem>();
        movedOrderItems.add((OrderItem)namedOrderItems.get(0));
        Order cart = this.orderService.createNewCartForCustomer(namedOrder.getCustomer());
        this.orderService.setMoveNamedOrderItems(false);
        cart = this.orderService.addItemFromNamedOrder(namedOrder, (OrderItem)movedOrderItems.get(0), true);
        this.orderService.setMoveNamedOrderItems(true);
        assert (this.cartContainsOnlyTheseItems(cart, movedOrderItems));
    }

    @Test(groups={"testCartAndNamedOrder"})
    @Transactional
    public void testMoveItemToCartFromNamedOrder() throws RemoveFromCartException, AddToCartException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        ArrayList<OrderItem> movedOrderItems = new ArrayList<OrderItem>();
        movedOrderItems.add((OrderItem)namedOrderItems.get(0));
        Order cart = this.orderService.createNewCartForCustomer(namedOrder.getCustomer());
        cart = this.orderService.addItemFromNamedOrder(namedOrder, (OrderItem)movedOrderItems.get(0), true);
        List customerNamedOrders = this.orderService.findOrdersForCustomer(namedOrder.getCustomer(), OrderStatus.NAMED);
        assert (customerNamedOrders.size() == 0);
        assert (cart.getOrderItems().size() == 1);
        assert (namedOrder.getOrderItems().size() == 0);
        assert (this.cartContainsOnlyTheseItems(cart, movedOrderItems));
    }

    @Test(groups={"testCartAndNamedOrder"})
    @Transactional
    public void testMoveItemToCartFromNamedOrderWithoutExistingCart() throws RemoveFromCartException, AddToCartException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        ArrayList<OrderItem> movedOrderItems = new ArrayList<OrderItem>();
        movedOrderItems.add((OrderItem)namedOrderItems.get(0));
        Order cart = this.orderService.addItemFromNamedOrder(namedOrder, (OrderItem)movedOrderItems.get(0), true);
        List customerNamedOrders = this.orderService.findOrdersForCustomer(namedOrder.getCustomer(), OrderStatus.NAMED);
        assert (customerNamedOrders.size() == 0);
        assert (cart.getOrderItems().size() == 1);
        assert (namedOrder.getOrderItems().size() == 0);
        assert (this.cartContainsOnlyTheseItems(cart, movedOrderItems));
    }
}

