/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.controller.validator;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.service.CustomerPhoneService;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component(value="blCustomerPhoneValidator")
public class CustomerPhoneValidator
implements Validator {
    @Resource(name="blCustomerPhoneService")
    private final CustomerPhoneService customerPhoneService = null;

    public boolean supports(Class clazz) {
        return clazz.equals(Phone.class);
    }

    public void validate(Object obj, Errors errors) {
        CustomerPhone cPhone = (CustomerPhone)obj;
        if (!errors.hasErrors()) {
            List<CustomerPhone> phones = this.customerPhoneService.readAllCustomerPhonesByCustomerId(cPhone.getCustomer().getId());
            String phoneNum = cPhone.getPhone().getPhoneNumber();
            String phoneName = cPhone.getPhoneName();
            Long phoneId = cPhone.getPhone().getId();
            Long customerPhoneId = cPhone.getId();
            boolean foundPhoneIdForUpdate = false;
            boolean foundCustomerPhoneIdForUpdate = false;
            for (CustomerPhone existingPhone : phones) {
                if (phoneId != null && !foundPhoneIdForUpdate && existingPhone.getPhone().getId().equals(phoneId)) {
                    foundPhoneIdForUpdate = true;
                }
                if (customerPhoneId != null && !foundCustomerPhoneIdForUpdate && existingPhone.getId().equals(customerPhoneId)) {
                    foundCustomerPhoneIdForUpdate = true;
                }
                if (existingPhone.getId().equals(cPhone.getId())) continue;
                if (phoneNum.equals(existingPhone.getPhone().getPhoneNumber())) {
                    errors.pushNestedPath("phone");
                    errors.rejectValue("phoneNumber", "phoneNumber.duplicate", null);
                    errors.popNestedPath();
                }
                if (!phoneName.equalsIgnoreCase(existingPhone.getPhoneName())) continue;
                errors.rejectValue("phoneName", "phoneName.duplicate", null);
            }
            if (phoneId != null && !foundPhoneIdForUpdate) {
                errors.pushNestedPath("phone");
                errors.rejectValue("id", "phone.invalid_id", null);
                errors.popNestedPath();
            }
            if (customerPhoneId != null && !foundCustomerPhoneIdForUpdate) {
                errors.rejectValue("id", "phone.invalid_id", null);
            }
        }
    }
}

