/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service.handler;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.email.service.EmailService;
import org.broadleafcommerce.common.email.service.info.EmailInfo;
import org.broadleafcommerce.common.security.util.PasswordReset;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.handler.PasswordUpdatedHandler;

public class EmailNotificationPasswordUpdatedHandler
implements PasswordUpdatedHandler {
    private static final Log LOG = LogFactory.getLog(EmailNotificationPasswordUpdatedHandler.class);
    public static final String CUSTOMER_PASSWORD_TEMPLATE_VARIABLE = "customerPasswordTemplateVariable";
    @Resource(name="blEmailService")
    protected EmailService emailService;
    protected Map<Locale, String> passwordResetEmailSubject = new HashMap<Locale, String>();
    protected Map<Locale, String> passwordResetEmailTemplate = new HashMap<Locale, String>();
    protected String passwordResetEmailFromAddress;
    protected Locale passwordResetEmailDefaultLocale = Locale.US;

    @Override
    public void passwordChanged(PasswordReset passwordReset, Customer customer, String newPassword) {
        String template;
        String subject;
        Locale localeToUse = null;
        org.broadleafcommerce.common.locale.domain.Locale blLocale = customer.getCustomerLocale();
        if (blLocale != null) {
            String[] splitLocale = blLocale.getLocaleCode().split("_");
            localeToUse = splitLocale.length > 1 ? new Locale(splitLocale[0], splitLocale[1]) : new Locale(splitLocale[0]);
        }
        if (localeToUse == null) {
            localeToUse = this.getPasswordResetEmailDefaultLocale();
        }
        if ((subject = this.getPasswordResetEmailSubject().get(localeToUse)) == null) {
            LOG.warn((Object)("Unable to find an email subject for customer locale: " + localeToUse.toString() + ". Using default locale instead."));
            subject = this.getPasswordResetEmailSubject().get(this.getPasswordResetEmailDefaultLocale());
        }
        if ((template = this.getPasswordResetEmailTemplate().get(localeToUse)) == null) {
            LOG.warn((Object)("Unable to find an email template for customer locale: " + localeToUse.toString() + ". Using default locale instead."));
            template = this.getPasswordResetEmailTemplate().get(this.getPasswordResetEmailDefaultLocale());
        }
        EmailInfo info = new EmailInfo();
        info.setFromAddress(this.getPasswordResetEmailFromAddress());
        info.setSubject(subject);
        info.setEmailTemplate(template);
        info.setSendEmailReliableAsync(String.valueOf(passwordReset.isSendResetEmailReliableAsync()));
        HashMap vars = this.constructPasswordChangeEmailTemplateVariables(customer, newPassword);
        this.emailService.sendTemplateEmail(passwordReset.getEmail(), info, (HashMap<String, Object>)vars);
    }

    protected HashMap constructPasswordChangeEmailTemplateVariables(Customer customer, String newPassword) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(CUSTOMER_PASSWORD_TEMPLATE_VARIABLE, newPassword);
        return vars;
    }

    public Map<Locale, String> getPasswordResetEmailSubject() {
        return this.passwordResetEmailSubject;
    }

    public void setPasswordResetEmailSubject(Map<Locale, String> passwordResetEmailSubject) {
        this.passwordResetEmailSubject = passwordResetEmailSubject;
    }

    public Map<Locale, String> getPasswordResetEmailTemplate() {
        return this.passwordResetEmailTemplate;
    }

    public void setPasswordResetEmailTemplate(Map<Locale, String> passwordResetEmailTemplate) {
        this.passwordResetEmailTemplate = passwordResetEmailTemplate;
    }

    public String getPasswordResetEmailFromAddress() {
        return this.passwordResetEmailFromAddress;
    }

    public void setPasswordResetEmailFromAddress(String passwordResetEmailFromAddress) {
        this.passwordResetEmailFromAddress = passwordResetEmailFromAddress;
    }

    public Locale getPasswordResetEmailDefaultLocale() {
        return this.passwordResetEmailDefaultLocale;
    }

    public void setPasswordResetEmailDefaultLocale(Locale passwordResetEmailDefaultLocale) {
        this.passwordResetEmailDefaultLocale = passwordResetEmailDefaultLocale;
    }
}

