/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.layout.tags;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.content.domain.Content;
import org.broadleafcommerce.core.content.service.ContentService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ContentSpecifiedTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> parameterMap;
    private String contentType;
    private Object xslt;
    private boolean escapeXml;
    private int rowCount;

    public ContentSpecifiedTag() {
        this.init();
    }

    private void init() {
        this.escapeXml = true;
        this.rowCount = -1;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, Object> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public Object getXslt() {
        return this.xslt;
    }

    public void setXslt(Object xslt) {
        this.xslt = xslt;
    }

    public boolean isEscapeXml() {
        return this.escapeXml;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int doStartTag() throws JspException {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.pageContext.getServletContext());
        ContentService contentService = (ContentService)applicationContext.getBean("blContentService");
        Date displayDate = null;
        String sandbox = "PROD";
        HttpSession session = this.pageContext.getSession();
        if (session != null) {
            String newSandbox = (String)session.getAttribute("BLC_CONTENT_SANDBOX");
            String displayDateString = (String)session.getAttribute("BLC_CONTENT_DATE_TIME");
            if (newSandbox != null && newSandbox != "") {
                sandbox = newSandbox;
            }
            if (displayDateString != null && displayDateString != "") {
                try {
                    displayDate = new SimpleDateFormat("MM-dd-yyyy").parse(displayDateString);
                }
                catch (ParseException exp) {
                    throw new JspException();
                }
            }
        }
        List<Content> contentObjs = displayDate == null ? contentService.findContent(sandbox, this.contentType, this.parameterMap, SystemTime.asDate()) : contentService.findContent(sandbox, this.contentType, this.parameterMap, displayDate);
        JspWriter out = this.pageContext.getOut();
        try {
            String renderedText = contentService.renderedContent((String)this.xslt, contentObjs, this.rowCount);
            if (!this.escapeXml) {
                out.write(renderedText);
            } else {
                ContentSpecifiedTag.writeEscapedXml(renderedText.toCharArray(), renderedText.length(), out);
            }
        }
        catch (Exception e) {
            throw new JspException();
        }
        return 6;
    }

    private static void writeEscapedXml(char[] buffer, int length, JspWriter w) throws IOException {
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char[] escaped;
            char c = buffer[i];
            if (c > '>' || (escaped = Util.specialCharactersRepresentation[c]) == null) continue;
            if (start < i) {
                w.write(buffer, start, i - start);
            }
            w.write(escaped);
            start = i + 1;
        }
        if (start < length) {
            w.write(buffer, start, length - start);
        }
    }
}

