/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.order;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.controller.order.CartController;
import org.broadleafcommerce.core.web.order.model.AddToCartItem;
import org.broadleafcommerce.core.web.order.model.CartOrderItem;
import org.broadleafcommerce.core.web.order.model.CartSummary;
import org.broadleafcommerce.core.web.order.model.WishlistRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="blWishlistController")
@RequestMapping(value={"/wishlist"})
public class WishlistController
extends CartController {
    private static final Log LOG = LogFactory.getLog(WishlistController.class);

    @RequestMapping(method={RequestMethod.POST}, params={"addToWishlist"})
    public String addToWishlist(ModelMap model, HttpServletRequest request, @ModelAttribute WishlistRequest wishlistRequest, BindingResult errors) {
        if (wishlistRequest.getWishlistName() != null && wishlistRequest.getWishlistName().length() > 0) {
            Order wishlist = this.cartService.findNamedOrderForCustomer(wishlistRequest.getWishlistName(), this.customerState.getCustomer(request));
            AddToCartItem addToCartItem = new AddToCartItem();
            addToCartItem.setCategoryId(wishlistRequest.getAddCategoryId());
            addToCartItem.setOrderId(wishlist.getId());
            addToCartItem.setProductId(wishlistRequest.getAddProductId());
            addToCartItem.setQuantity(1);
            addToCartItem.setSkuId(wishlistRequest.getAddSkuId());
            this.addItem(false, addToCartItem, errors, model, request);
            return this.viewWishlist(model, request, wishlist.getId());
        }
        model.addAttribute("wishlistRequest", (Object)wishlistRequest);
        return this.createWishlistName(model, request);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showWishlists(ModelMap model, HttpServletRequest request) {
        List<Order> wishlistOrders = this.cartService.findOrdersForCustomer(this.customerState.getCustomer(request), OrderStatus.NAMED);
        model.addAttribute("wishlists", wishlistOrders);
        return "wishlist/showWishlists";
    }

    @RequestMapping(method={RequestMethod.GET})
    public String viewWishlist(ModelMap model, HttpServletRequest request, @RequestParam(value="id") Long id) {
        Order wishlist = this.cartService.findOrderById(id);
        CartSummary cartSummary = new CartSummary();
        if (wishlist == null) {
            return "redirect:/basket/currentCart.htm";
        }
        if (wishlist.getOrderItems() != null) {
            for (OrderItem orderItem : wishlist.getOrderItems()) {
                CartOrderItem cartOrderItem = new CartOrderItem();
                cartOrderItem.setOrderItem(orderItem);
                cartOrderItem.setQuantity(orderItem.getQuantity());
                cartSummary.getRows().add(cartOrderItem);
            }
        }
        model.addAttribute("cartSummary", (Object)cartSummary);
        model.addAttribute("wishlist", (Object)wishlist);
        return "wishlist/viewWishlist";
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String createWishlist(ModelMap model, HttpServletRequest request, @ModelAttribute WishlistRequest wishlistRequest) {
        boolean wishlistCreated = false;
        Order wishlistOrder = new OrderImpl();
        if (wishlistRequest.getWishlistName() != null && wishlistRequest.getWishlistName().length() > 0) {
            wishlistOrder = this.createWishlistCart(request, wishlistRequest.getWishlistName());
            wishlistCreated = true;
        }
        if (!wishlistCreated) {
            model.addAttribute("wishlistError", (Object)"Please enter a valid wishlist name.");
            return "wishlist/createWishlistName";
        }
        if (wishlistRequest.getAddSkuId() != null && wishlistRequest.getAddCategoryId() != null && wishlistRequest.getAddProductId() != null && wishlistRequest.getQuantity() != null && wishlistCreated) {
            try {
                this.cartService.addSkuToOrder(wishlistOrder.getId(), wishlistRequest.getAddSkuId(), wishlistRequest.getAddProductId(), wishlistRequest.getAddCategoryId(), wishlistRequest.getQuantity());
            }
            catch (PricingException e) {
                LOG.error((Object)("An exception occured while pricing the order: (" + wishlistOrder.getId() + ")"), (Throwable)e);
            }
        }
        return this.viewWishlist(model, request, wishlistOrder.getId());
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String createWishlistName(ModelMap model, HttpServletRequest request) {
        WishlistRequest wishlistRequest = (WishlistRequest)model.get((Object)"wishlistRequest");
        if (wishlistRequest != null) {
            model.addAttribute("wishlistRequest", model.get((Object)"wishlistRequest"));
        } else {
            model.addAttribute("wishlistRequest", (Object)new WishlistRequest());
        }
        return "wishlist/createWishlistName";
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String removeWishlist(@RequestParam String wishlistName, ModelMap model, HttpServletRequest request) {
        this.cartService.removeNamedOrderForCustomer(wishlistName, this.customerState.getCustomer(request));
        return this.showWishlists(model, request);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String removeWishlistItem(@RequestParam long orderItemId, @RequestParam long orderId, ModelMap model, HttpServletRequest request) {
        Order wishlist = this.cartService.findOrderById(orderId);
        try {
            wishlist = this.cartService.removeItemFromOrder(wishlist.getId(), orderItemId);
        }
        catch (PricingException e) {
            LOG.error((Object)("An error occurred while removing an item from the cart: (" + orderItemId + ")"), (Throwable)e);
        }
        return this.viewWishlist(model, request, wishlist.getId());
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String moveItemToCart(@RequestParam long orderItemId, @RequestParam String wishlistName, ModelMap model, HttpServletRequest request) {
        Order wishlistOrder = this.cartService.findNamedOrderForCustomer(wishlistName, this.customerState.getCustomer(request));
        try {
            this.cartService.moveItemToCartFromNamedOrder(this.customerState.getCustomer(request).getId(), wishlistOrder.getName(), orderItemId, new Integer(1));
        }
        catch (Exception e) {
            LOG.error((Object)("An exception occured while pricing the order: (" + wishlistOrder.getId() + ")"), (Throwable)e);
        }
        return this.viewWishlist(model, request, wishlistOrder.getId());
    }

    @RequestMapping(method={RequestMethod.GET})
    public String moveAllItemsToCart(@RequestParam String wishlistName, ModelMap model, HttpServletRequest request) {
        Order wishlistOrder = this.cartService.findNamedOrderForCustomer(wishlistName, this.customerState.getCustomer(request));
        try {
            this.cartService.moveAllItemsToCartFromNamedOrder(wishlistOrder);
        }
        catch (PricingException e) {
            LOG.error((Object)("An exception occured while pricing the order: (" + wishlistOrder.getId() + ")"), (Throwable)e);
        }
        return "redirect:/basket/viewCart.htm";
    }

    protected Order createWishlistCart(HttpServletRequest request, String wishlistName) {
        Order currentWishlistOrder = this.cartService.createNamedOrderForCustomer(wishlistName, this.customerState.getCustomer(request));
        return currentWishlistOrder;
    }
}

