/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.order;

import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.order.model.FindOrderForm;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="viewOrderController")
@RequestMapping(value={"/orders"})
public class ViewOrderController {
    @Resource(name="blCustomerState")
    private CustomerState customerState;
    @Resource(name="blCartService")
    protected CartService cartService;

    @RequestMapping(method={RequestMethod.GET})
    public String viewOrders(ModelMap model, HttpServletRequest request) throws PricingException {
        List<Order> orders = this.cartService.findOrdersForCustomer(this.customerState.getCustomer(request), OrderStatus.SUBMITTED);
        model.addAttribute("orderList", orders);
        return "listOrders";
    }

    @RequestMapping(method={RequestMethod.GET})
    public String viewOrderDetails(ModelMap model, HttpServletRequest request, @RequestParam(required=true) String orderNumber) {
        Order order = this.cartService.findOrderByOrderNumber(orderNumber);
        if (order == null) {
            return "findOrderError";
        }
        model.addAttribute("order", (Object)order);
        return "viewOrderDetails";
    }

    @RequestMapping(method={RequestMethod.GET})
    public String viewOrderConfirmation(ModelMap model, HttpServletRequest request, @RequestParam(required=true) String orderNumber) {
        Order order = this.cartService.findOrderByOrderNumber(orderNumber);
        if (order == null) {
            return "findOrderError";
        }
        model.addAttribute("order", (Object)order);
        return "checkout/checkoutConfirmation";
    }

    @RequestMapping(method={RequestMethod.GET})
    public String findOrder(ModelMap model, HttpServletRequest request) {
        model.addAttribute("findOrderForm", (Object)new FindOrderForm());
        return "findOrder";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String processFindOrder(@ModelAttribute FindOrderForm findOrderForm, ModelMap model, HttpServletRequest request) {
        Order order = this.cartService.findOrderByOrderNumber(findOrderForm.getOrderNumber());
        if (order == null) {
            return "findOrderError";
        }
        List<FulfillmentGroup> orderFulfillmentGroups = order.getFulfillmentGroups();
        if (orderFulfillmentGroups != null) {
            for (FulfillmentGroup fulfillmentGroup : orderFulfillmentGroups) {
                if (!fulfillmentGroup.getAddress().getPostalCode().equals(findOrderForm.getPostalCode())) continue;
                return this.viewOrderDetails(model, request, order.getOrderNumber());
            }
        }
        return "findOrderError";
    }
}

