/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationOverride;
import org.broadleafcommerce.common.presentation.AdminPresentationOverrides;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustmentImpl;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.domain.OrderItemAttributeImpl;
import org.broadleafcommerce.core.order.domain.PersonalMessage;
import org.broadleafcommerce.core.order.domain.PersonalMessageImpl;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemVisitor;
import org.broadleafcommerce.core.order.service.type.OrderItemType;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationOverrides(value={@AdminPresentationOverride(name="product.defaultCategory", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="product.name", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="product.description", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="product.longDescription", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="product.activeStartDate", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="product.activeEndDate", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="product.sku", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="sku.name", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="sku.salePrice", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="sku.retailPrice", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="bundleOrderItem", value=@AdminPresentation(excluded=true))})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="baseOrderItem")
public class OrderItemImpl
implements OrderItem,
Cloneable {
    private static final Log LOG = LogFactory.getLog(OrderItemImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderItemId", strategy=GenerationType.TABLE)
    @TableGenerator(name="OrderItemId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="OrderItemImpl", allocationSize=50)
    @Column(name="ORDER_ITEM_ID")
    @AdminPresentation(friendlyName="Order Item ID", group="Primary Key", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="CATEGORY_ID")
    @Index(name="ORDERITEM_CATEGORY_INDEX", columnNames={"CATEGORY_ID"})
    @NotFound(action=NotFoundAction.IGNORE)
    @AdminPresentation(excluded=true)
    protected Category category;
    @ManyToOne(targetEntity=OrderImpl.class)
    @JoinColumn(name="ORDER_ID")
    @Index(name="ORDERITEM_ORDER_INDEX", columnNames={"ORDER_ID"})
    @AdminPresentation(excluded=true, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Order order;
    @Column(name="RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="Item Retail Price", order=2, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal retailPrice;
    @Column(name="SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="Item Sale Price", order=3, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal salePrice;
    @Column(name="PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="Item Price", order=4, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal price;
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="Item Quantity", order=5, group="Pricing")
    protected int quantity;
    @Column(name="NAME")
    @AdminPresentation(friendlyName="Item Name", order=1, group="Description", prominent=true, groupOrder=1)
    protected String name;
    @ManyToOne(targetEntity=PersonalMessageImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="PERSONAL_MESSAGE_ID")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @Index(name="ORDERITEM_MESSAGE_INDEX", columnNames={"PERSONAL_MESSAGE_ID"})
    protected PersonalMessage personalMessage;
    @ManyToOne(targetEntity=GiftWrapOrderItemImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="GIFT_WRAP_ITEM_ID", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @Index(name="ORDERITEM_GIFT_INDEX", columnNames={"GIFT_WRAP_ITEM_ID"})
    @AdminPresentation(excluded=true)
    protected GiftWrapOrderItem giftWrapOrderItem;
    @OneToMany(mappedBy="orderItem", targetEntity=OrderItemAdjustmentImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<OrderItemAdjustment> orderItemAdjustments = new ArrayList<OrderItemAdjustment>();
    @OneToMany(mappedBy="orderItem", targetEntity=CandidateItemOfferImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<CandidateItemOffer> candidateItemOffers = new ArrayList<CandidateItemOffer>();
    @Column(name="ORDER_ITEM_TYPE")
    @Index(name="ORDERITEM_TYPE_INDEX", columnNames={"ORDER_ITEM_TYPE"})
    @AdminPresentation(excluded=true)
    protected String orderItemType;
    @OneToMany(mappedBy="orderItem", targetEntity=OrderItemAttributeImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @MapKey(name="value")
    protected Map<String, OrderItemAttribute> orderItemAttributeMap;

    @Override
    public Money getRetailPrice() {
        return this.retailPrice == null ? null : new Money(this.retailPrice);
    }

    @Override
    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = Money.toAmount(retailPrice);
    }

    @Override
    public Money getSalePrice() {
        return this.salePrice == null ? null : new Money(this.salePrice);
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.salePrice = Money.toAmount(salePrice);
    }

    @Override
    public Money getPrice() {
        return this.price == null ? null : new Money(this.price);
    }

    @Override
    public void setPrice(Money finalPrice) {
        this.price = Money.toAmount(finalPrice);
    }

    @Override
    public Money getTaxablePrice() {
        return this.getPrice();
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category category) {
        this.category = category;
    }

    @Override
    public List<CandidateItemOffer> getCandidateItemOffers() {
        return this.candidateItemOffers;
    }

    @Override
    public void setCandidateItemOffers(List<CandidateItemOffer> candidateItemOffers) {
        this.candidateItemOffers = candidateItemOffers;
    }

    @Override
    public PersonalMessage getPersonalMessage() {
        return this.personalMessage;
    }

    @Override
    public void setPersonalMessage(PersonalMessage personalMessage) {
        this.personalMessage = personalMessage;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isInCategory(String categoryName) {
        Category currentCategory = this.category;
        if (currentCategory != null) {
            if (currentCategory.getName().equals(categoryName)) {
                return true;
            }
            while ((currentCategory = currentCategory.getDefaultParentCategory()) != null) {
                if (!currentCategory.getName().equals(categoryName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<OrderItemAdjustment> getOrderItemAdjustments() {
        return this.orderItemAdjustments;
    }

    @Override
    public void setOrderItemAdjustments(List<OrderItemAdjustment> orderItemAdjustments) {
        this.orderItemAdjustments = orderItemAdjustments;
    }

    @Override
    public Money getAdjustmentValue() {
        Money adjustmentValue = new Money(0);
        for (OrderItemAdjustment itemAdjustment : this.orderItemAdjustments) {
            adjustmentValue = adjustmentValue.add(itemAdjustment.getValue());
        }
        return adjustmentValue;
    }

    @Override
    public GiftWrapOrderItem getGiftWrapOrderItem() {
        return this.giftWrapOrderItem;
    }

    @Override
    public void setGiftWrapOrderItem(GiftWrapOrderItem giftWrapOrderItem) {
        this.giftWrapOrderItem = giftWrapOrderItem;
    }

    @Override
    public OrderItemType getOrderItemType() {
        return OrderItemType.getInstance(this.orderItemType);
    }

    @Override
    public void setOrderItemType(OrderItemType orderItemType) {
        this.orderItemType = orderItemType.getType();
    }

    @Override
    public boolean getIsOnSale() {
        if (this.getSalePrice() != null) {
            return !this.getSalePrice().equals(this.getRetailPrice());
        }
        return false;
    }

    @Override
    public boolean getIsDiscounted() {
        if (this.getPrice() != null) {
            return !this.getPrice().equals(this.getRetailPrice());
        }
        return false;
    }

    @Override
    public boolean updatePrices() {
        return false;
    }

    @Override
    public void assignFinalPrice() {
        this.setPrice(this.getCurrentPrice());
    }

    @Override
    public Money getCurrentPrice() {
        this.updatePrices();
        Money currentPrice = null;
        currentPrice = this.getPrice() != null ? this.getPrice() : (this.getSalePrice() != null ? this.getSalePrice() : this.getRetailPrice());
        return currentPrice;
    }

    @Override
    public Money getPriceBeforeAdjustments(boolean allowSalesPrice) {
        this.updatePrices();
        Money currentPrice = null;
        currentPrice = this.getSalePrice() != null && allowSalesPrice ? this.getSalePrice() : this.getRetailPrice();
        return currentPrice;
    }

    @Override
    public void addCandidateItemOffer(CandidateItemOffer candidateItemOffer) {
        this.getCandidateItemOffers().add(candidateItemOffer);
    }

    @Override
    public void removeAllCandidateItemOffers() {
        if (this.getCandidateItemOffers() != null) {
            for (CandidateItemOffer candidate : this.getCandidateItemOffers()) {
                candidate.setOrderItem(null);
            }
            this.getCandidateItemOffers().clear();
        }
    }

    @Override
    public int removeAllAdjustments() {
        int removedAdjustmentCount = 0;
        if (this.getOrderItemAdjustments() != null) {
            for (OrderItemAdjustment adjustment : this.getOrderItemAdjustments()) {
                adjustment.setOrderItem(null);
            }
            removedAdjustmentCount = this.getOrderItemAdjustments().size();
            this.getOrderItemAdjustments().clear();
        }
        this.assignFinalPrice();
        return removedAdjustmentCount;
    }

    @Override
    public Map<String, OrderItemAttribute> getOrderItemAttributes() {
        return this.orderItemAttributeMap;
    }

    @Override
    public void setOrderItemAttributes(Map<String, OrderItemAttribute> orderItemAttributes) {
        this.orderItemAttributeMap = orderItemAttributes;
    }

    public void checkCloneable(OrderItem orderItem) throws CloneNotSupportedException, SecurityException, NoSuchMethodException {
        Method cloneMethod = orderItem.getClass().getMethod("clone", new Class[0]);
        if (cloneMethod.getDeclaringClass().getName().startsWith("org.broadleafcommerce") && !orderItem.getClass().getName().startsWith("org.broadleafcommerce")) {
            throw new CloneNotSupportedException("Custom extensions and implementations should implement clone in order to guarantee split and merge operations are performed accurately");
        }
    }

    @Override
    public OrderItem clone() {
        OrderItem orderItem;
        try {
            Serializable clone;
            orderItem = (OrderItem)Class.forName(this.getClass().getName()).newInstance();
            try {
                this.checkCloneable(orderItem);
            }
            catch (CloneNotSupportedException e) {
                LOG.warn((Object)("Clone implementation missing in inheritance hierarchy outside of Broadleaf: " + orderItem.getClass().getName()), (Throwable)e);
            }
            if (this.getCandidateItemOffers() != null) {
                for (CandidateItemOffer candidate : this.getCandidateItemOffers()) {
                    clone = candidate.clone();
                    clone.setOrderItem(orderItem);
                    orderItem.getCandidateItemOffers().add((CandidateItemOffer)clone);
                }
            }
            if (this.getOrderItemAttributes() != null) {
                for (OrderItemAttribute attribute : this.getOrderItemAttributes().values()) {
                    clone = attribute.clone();
                    clone.setOrderItem(orderItem);
                    orderItem.getOrderItemAttributes().put(clone.getName(), (OrderItemAttribute)clone);
                }
            }
            orderItem.setCategory(this.getCategory());
            orderItem.setGiftWrapOrderItem(this.getGiftWrapOrderItem());
            orderItem.setName(this.getName());
            orderItem.setOrder(this.getOrder());
            orderItem.setOrderItemType(this.getOrderItemType());
            orderItem.setPersonalMessage(this.getPersonalMessage());
            orderItem.setQuantity(this.getQuantity());
            orderItem.setRetailPrice(this.getRetailPrice());
            orderItem.setSalePrice(this.getSalePrice());
            orderItem.setPrice(this.getPrice());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return orderItem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.giftWrapOrderItem == null ? 0 : this.giftWrapOrderItem.hashCode());
        result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
        result = 31 * result + (this.orderItemType == null ? 0 : this.orderItemType.hashCode());
        result = 31 * result + (this.personalMessage == null ? 0 : this.personalMessage.hashCode());
        result = 31 * result + (this.price == null ? 0 : this.price.hashCode());
        result = 31 * result + this.quantity;
        result = 31 * result + (this.retailPrice == null ? 0 : this.retailPrice.hashCode());
        result = 31 * result + (this.salePrice == null ? 0 : this.salePrice.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderItemImpl other = (OrderItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.giftWrapOrderItem == null ? other.giftWrapOrderItem != null : !this.giftWrapOrderItem.equals(other.giftWrapOrderItem)) {
            return false;
        }
        if (this.order == null ? other.order != null : !this.order.equals(other.order)) {
            return false;
        }
        if (this.orderItemType == null ? other.orderItemType != null : !this.orderItemType.equals(other.orderItemType)) {
            return false;
        }
        if (this.personalMessage == null ? other.personalMessage != null : !this.personalMessage.equals(other.personalMessage)) {
            return false;
        }
        if (this.price == null ? other.price != null : !this.price.equals(other.price)) {
            return false;
        }
        if (this.quantity != other.quantity) {
            return false;
        }
        if (this.retailPrice == null ? other.retailPrice != null : !this.retailPrice.equals(other.retailPrice)) {
            return false;
        }
        return !(this.salePrice == null ? other.salePrice != null : !this.salePrice.equals(other.salePrice));
    }

    @Override
    public void accept(OrderItemVisitor visitor) throws PricingException {
        visitor.visit(this);
    }
}

