/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;

public class PromotableOrderAdjustmentImpl
implements PromotableOrderAdjustment {
    private static final long serialVersionUID = 1L;
    protected OrderAdjustment delegate;
    protected PromotableOrder order;

    public PromotableOrderAdjustmentImpl(OrderAdjustment orderAdjustment, PromotableOrder order) {
        this.delegate = orderAdjustment;
        this.order = order;
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public OrderAdjustment getDelegate() {
        return this.delegate;
    }

    @Override
    public void computeAdjustmentValue() {
        if (this.delegate.getOffer() != null && this.order != null) {
            BigDecimal offerValue;
            Money adjustmentPrice = this.order.getAdjustmentPrice();
            if (adjustmentPrice == null) {
                adjustmentPrice = this.order.getSubTotal();
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                this.delegate.setValue(new Money(this.delegate.getOffer().getValue(), adjustmentPrice.getCurrency(), 5));
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                offerValue = adjustmentPrice.getAmount().subtract(this.delegate.getOffer().getValue());
                this.delegate.setValue(new Money(offerValue, adjustmentPrice.getCurrency(), 5));
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                offerValue = adjustmentPrice.getAmount().multiply(this.delegate.getOffer().getValue().divide(new BigDecimal("100"), 5, RoundingMode.HALF_EVEN));
                this.delegate.setValue(new Money(offerValue, adjustmentPrice.getCurrency(), 5));
            }
            if (adjustmentPrice.lessThan(this.delegate.getValue())) {
                this.delegate.setValue(adjustmentPrice);
            }
        }
    }

    @Override
    public Money getValue() {
        if (this.delegate.getValue() == null || this.delegate.getValue().equals(Money.ZERO)) {
            this.computeAdjustmentValue();
        }
        return this.delegate.getValue();
    }
}

