/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.dao;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.offer.dao.OfferAuditDao;
import org.broadleafcommerce.core.offer.domain.OfferAudit;
import org.broadleafcommerce.core.offer.domain.OfferAuditImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blOfferAuditDao")
public class OfferAuditDaoImpl
implements OfferAuditDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public OfferAudit create() {
        return (OfferAudit)this.entityConfiguration.createEntityInstance(OfferAudit.class.getName());
    }

    @Override
    public void delete(OfferAudit offerAudit) {
        OfferAudit loa = offerAudit;
        if (!this.em.contains((Object)loa)) {
            loa = this.readAuditById(offerAudit.getId());
        }
        this.em.remove((Object)loa);
    }

    @Override
    public OfferAudit save(OfferAudit offerAudit) {
        return (OfferAudit)this.em.merge((Object)offerAudit);
    }

    @Override
    public OfferAudit readAuditById(Long offerAuditId) {
        return (OfferAudit)this.em.find(this.entityConfiguration.lookupEntityClass(OfferAudit.class.getName()), (Object)offerAuditId);
    }

    @Override
    public Long countUsesByCustomer(Long customerId, Long offerId) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        cq.select((Selection)cb.count((Expression)cq.from(OfferAuditImpl.class)));
        Root from = cq.from(OfferAuditImpl.class);
        Predicate customerIdClause = cb.equal((Expression)from.get("customerId"), (Object)customerId);
        Predicate offerIdClause = cb.equal((Expression)from.get("offerId"), (Object)offerId);
        cq.where((Expression)cb.and((Expression)customerIdClause, (Expression)offerIdClause));
        Long result = (Long)this.em.createQuery(cq).getSingleResult();
        return result;
    }
}

