/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductSku;
import org.broadleafcommerce.core.catalog.service.type.ProductType;
import org.springframework.stereotype.Repository;

@Repository(value="blProductDao")
public class ProductDaoImpl
implements ProductDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected Long currentDateResolution = 10000L;
    private Date currentDate = SystemTime.asDate();

    @Override
    public Product save(Product product) {
        return (Product)this.em.merge((Object)product);
    }

    @Override
    public Product readProductById(Long productId) {
        return (Product)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.core.catalog.domain.Product"), (Object)productId);
    }

    @Override
    public List<Product> readProductsByName(String searchName) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_NAME", Product.class);
        query.setParameter("name", (Object)(searchName + '%'));
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Product> readActiveProductsByCategory(Long categoryId, Date currentDate) {
        Date myDate;
        Long myCurrentDateResolution = this.currentDateResolution;
        ProductDaoImpl productDaoImpl = this;
        synchronized (productDaoImpl) {
            if (currentDate.getTime() - this.currentDate.getTime() > myCurrentDateResolution) {
                this.currentDate = new Date(currentDate.getTime());
                myDate = currentDate;
            } else {
                myDate = this.currentDate;
            }
        }
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)categoryId);
        query.setParameter("currentDate", (Object)myDate);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsByCategory(Long categoryId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)categoryId);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsBySku(Long skuId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_SKU", Product.class);
        query.setParameter("skuId", (Object)skuId);
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    @Override
    public List<ProductSku> readProductsBySkuOneToOne(Long skuId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_SKU_ONE_TO_ONE", ProductSku.class);
        query.setParameter("skuId", (Object)skuId);
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Product> readActiveProductsBySku(Long skuId, Date currentDate) {
        Date myDate;
        Long myCurrentDateResolution = this.currentDateResolution;
        ProductDaoImpl productDaoImpl = this;
        synchronized (productDaoImpl) {
            if (currentDate.getTime() - this.currentDate.getTime() > myCurrentDateResolution) {
                this.currentDate = new Date(currentDate.getTime());
                myDate = currentDate;
            } else {
                myDate = this.currentDate;
            }
        }
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_SKU", Product.class);
        query.setParameter("skuId", (Object)skuId);
        query.setParameter("currentDate", (Object)myDate);
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProductSku> readActiveProductsBySkuOneToOne(Long skuId, Date currentDate) {
        Date myDate;
        Long myCurrentDateResolution = this.currentDateResolution;
        ProductDaoImpl productDaoImpl = this;
        synchronized (productDaoImpl) {
            if (currentDate.getTime() - this.currentDate.getTime() > myCurrentDateResolution) {
                this.currentDate = new Date(currentDate.getTime());
                myDate = currentDate;
            } else {
                myDate = this.currentDate;
            }
        }
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_SKU_ONE_TO_ONE", ProductSku.class);
        query.setParameter("skuId", (Object)skuId);
        query.setParameter("currentDate", (Object)myDate);
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    @Override
    public void delete(Product product) {
        if (!this.em.contains((Object)product)) {
            product = this.readProductById(product.getId());
        }
        this.em.remove((Object)product);
    }

    @Override
    public Product create(ProductType productType) {
        return (Product)this.entityConfiguration.createEntityInstance(productType.getType());
    }

    public Long getCurrentDateResolution() {
        return this.currentDateResolution;
    }

    public void setCurrentDateResolution(Long currentDateResolution) {
        this.currentDateResolution = currentDateResolution;
    }
}

