/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.vendor.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class ContainerSizeType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ContainerSizeType> TYPES = new HashMap<String, ContainerSizeType>();
    private String type;
    private String friendlyType;

    public static ContainerSizeType getInstance(String type) {
        return TYPES.get(type);
    }

    public ContainerSizeType() {
    }

    public ContainerSizeType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (TYPES.containsKey(type)) {
            throw new RuntimeException("Cannot add the type: (" + type + "). It already exists as a type via " + ContainerSizeType.getInstance(type).getClass().getName());
        }
        TYPES.put(type, this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerSizeType other = (ContainerSizeType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

