/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.security.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.security.util.CookieUtils;
import org.broadleafcommerce.common.security.util.ServerCookie;
import org.springframework.stereotype.Component;

@Component(value="blCookieUtils")
public class GenericCookieUtilsImpl
implements CookieUtils {
    @Override
    public String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public void setCookieValue(HttpServletResponse response, String cookieName, String cookieValue, String path, Integer maxAge, Boolean isSecure) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setPath(path);
        if (maxAge != null) {
            cookie.setMaxAge(maxAge.intValue());
        }
        cookie.setSecure(isSecure.booleanValue());
        StringBuffer sb = new StringBuffer();
        ServerCookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure(), true);
        response.addHeader("Set-Cookie", sb.toString());
    }

    @Override
    public void setCookieValue(HttpServletResponse response, String cookieName, String cookieValue) {
        this.setCookieValue(response, cookieName, cookieValue, "/", null, false);
    }

    @Override
    public void invalidateCookie(HttpServletResponse response, String cookieName) {
        this.setCookieValue(response, cookieName, "", "/", 0, false);
    }
}

