/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.money;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;
import java.util.Locale;
import org.broadleafcommerce.common.money.BankersRounding;
import org.broadleafcommerce.common.money.CurrencyConsiderationContext;
import org.broadleafcommerce.common.money.NonModifiableMoney;

public class Money
implements Serializable,
Cloneable,
Comparable<Money>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private BigDecimal amount;
    private final Currency currency;
    public static final Money ZERO = new NonModifiableMoney(BigDecimal.ZERO);

    public Money() {
        this(BankersRounding.zeroAmount(), Money.defaultCurrency());
    }

    public Money(BigDecimal amount) {
        this(amount, Money.defaultCurrency());
    }

    public Money(double amount) {
        this(Money.valueOf(amount), Money.defaultCurrency());
    }

    public Money(int amount) {
        this(BigDecimal.valueOf(amount).setScale(2, RoundingMode.HALF_EVEN), Money.defaultCurrency());
    }

    public Money(long amount) {
        this(BigDecimal.valueOf(amount).setScale(2, RoundingMode.HALF_EVEN), Money.defaultCurrency());
    }

    public Money(String amount) {
        this(Money.valueOf(amount), Money.defaultCurrency());
    }

    public Money(BigDecimal amount, String currencyCode) {
        this(amount, Currency.getInstance(currencyCode));
    }

    public Money(double amount, Currency currency) {
        this(Money.valueOf(amount), currency);
    }

    public Money(double amount, String currencyCode) {
        this(Money.valueOf(amount), Currency.getInstance(currencyCode));
    }

    public Money(int amount, Currency currency) {
        this(BigDecimal.valueOf(amount).setScale(2, RoundingMode.HALF_EVEN), currency);
    }

    public Money(int amount, String currencyCode) {
        this(BigDecimal.valueOf(amount).setScale(2, RoundingMode.HALF_EVEN), Currency.getInstance(currencyCode));
    }

    public Money(long amount, Currency currency) {
        this(BigDecimal.valueOf(amount).setScale(2, RoundingMode.HALF_EVEN), currency);
    }

    public Money(long amount, String currencyCode) {
        this(BigDecimal.valueOf(amount).setScale(2, RoundingMode.HALF_EVEN), Currency.getInstance(currencyCode));
    }

    public Money(String amount, Currency currency) {
        this(Money.valueOf(amount), currency);
    }

    public Money(String amount, String currencyCode) {
        this(Money.valueOf(amount), Currency.getInstance(currencyCode));
    }

    public Money(BigDecimal amount, Currency currency) {
        if (currency == null) {
            throw new IllegalArgumentException("currency cannot be null");
        }
        this.currency = currency;
        this.amount = amount.compareTo(new BigDecimal(".01")) > -1 ? BankersRounding.setScale(amount) : amount;
    }

    public Money(BigDecimal amount, Currency currency, int scale) {
        if (currency == null) {
            throw new IllegalArgumentException("currency cannot be null");
        }
        this.currency = currency;
        this.amount = BankersRounding.setScale(amount, scale);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Money add(Money other) {
        return new Money(this.amount.add(other.amount), this.currency, this.amount.scale() == 0 ? 2 : this.amount.scale());
    }

    public Money subtract(Money other) {
        return new Money(this.amount.subtract(other.amount), this.currency, this.amount.scale() == 0 ? 2 : this.amount.scale());
    }

    public Money multiply(double amount) {
        return this.multiply(Money.valueOf(amount));
    }

    public Money multiply(int amount) {
        BigDecimal value = BigDecimal.valueOf(amount);
        value = value.setScale(2, RoundingMode.HALF_EVEN);
        return this.multiply(value);
    }

    public Money multiply(BigDecimal multiplier) {
        return new Money(this.amount.multiply(multiplier), this.currency, this.amount.scale() == 0 ? 2 : this.amount.scale());
    }

    public Money divide(double amount) {
        return this.divide(Money.valueOf(amount));
    }

    public Money divide(int amount) {
        BigDecimal value = BigDecimal.valueOf(amount);
        value = value.setScale(2, RoundingMode.HALF_EVEN);
        return this.divide(value);
    }

    public Money divide(BigDecimal divisor) {
        return new Money(this.amount.divide(divisor, this.amount.precision(), RoundingMode.HALF_EVEN), this.currency, this.amount.scale() == 0 ? 2 : this.amount.scale());
    }

    public Money abs() {
        return new Money(this.amount.abs(), this.currency);
    }

    public Money min(Money other) {
        if (other == null) {
            return this;
        }
        return this.lessThan(other) ? this : other;
    }

    public Money max(Money other) {
        if (other == null) {
            return this;
        }
        return this.greaterThan(other) ? this : other;
    }

    public Money negate() {
        return new Money(this.amount.negate(), this.currency);
    }

    public boolean isZero() {
        return this.amount.compareTo(BankersRounding.zeroAmount()) == 0;
    }

    public Money zero() {
        return Money.zero(this.currency);
    }

    public boolean lessThan(Money other) {
        return this.compareTo(other) < 0;
    }

    public boolean lessThan(BigDecimal value) {
        return this.amount.compareTo(value) < 0;
    }

    public boolean lessThanOrEqual(Money other) {
        return this.compareTo(other) <= 0;
    }

    public boolean lessThanOrEqual(BigDecimal value) {
        return this.amount.compareTo(value) <= 0;
    }

    public boolean greaterThan(Money other) {
        return this.compareTo(other) > 0;
    }

    public boolean greaterThan(BigDecimal value) {
        return this.amount.compareTo(value) > 0;
    }

    public boolean greaterThanOrEqual(Money other) {
        return this.compareTo(other) >= 0;
    }

    public boolean greaterThanOrEqual(BigDecimal value) {
        return this.amount.compareTo(value) >= 0;
    }

    @Override
    public int compareTo(Money other) {
        return this.amount.compareTo(other.amount);
    }

    @Override
    public int compareTo(BigDecimal value) {
        return this.amount.compareTo(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Money)) {
            return false;
        }
        Money money = (Money)o;
        if (this.amount != null ? !this.amount.equals(money.amount) : money.amount != null) {
            return false;
        }
        return !(this.currency != null ? !this.currency.equals(money.currency) : money.currency != null);
    }

    public int hashCode() {
        int result = this.amount != null ? this.amount.hashCode() : 0;
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        return result;
    }

    public Object clone() {
        return new Money(this.amount, this.currency);
    }

    public String toString() {
        return this.amount.toString();
    }

    public double doubleValue() {
        try {
            return this.amount.doubleValue();
        }
        catch (NumberFormatException e) {
            if (e.getMessage().equals("For input string: \"0.00null\"")) {
                return this.amount.doubleValue();
            }
            throw e;
        }
    }

    public String stringValue() {
        return this.amount.toString() + " " + this.currency.getCurrencyCode();
    }

    public static Money zero(String currencyCode) {
        return Money.zero(Currency.getInstance(currencyCode));
    }

    public static Money zero(Currency currency) {
        return new Money(BankersRounding.zeroAmount(), currency);
    }

    public static Money abs(Money money) {
        return new Money(money.amount.abs(), money.currency);
    }

    public static Money min(Money left, Money right) {
        return left.min(right);
    }

    public static Money max(Money left, Money right) {
        return left.max(right);
    }

    public static BigDecimal toAmount(Money money) {
        return money == null ? null : money.amount;
    }

    public static Currency toCurrency(Money money) {
        return money == null ? null : money.currency;
    }

    private static BigDecimal valueOf(double amount) {
        return Money.valueOf(String.valueOf(amount));
    }

    private static BigDecimal valueOf(String amount) {
        BigDecimal value = new BigDecimal(amount);
        if (value.scale() < 2) {
            value = value.setScale(2, RoundingMode.HALF_EVEN);
        }
        return value;
    }

    public static Currency defaultCurrency() {
        if (CurrencyConsiderationContext.getCurrencyConsiderationContext() != null && CurrencyConsiderationContext.getCurrencyConsiderationContext().size() > 0 && CurrencyConsiderationContext.getCurrencyDeterminationService() != null) {
            return Currency.getInstance(CurrencyConsiderationContext.getCurrencyDeterminationService().getCurrencyCode(CurrencyConsiderationContext.getCurrencyConsiderationContext()));
        }
        if (System.getProperty("currency.default") != null) {
            return Currency.getInstance(System.getProperty("currency.default"));
        }
        Locale locale = Locale.getDefault();
        if (locale.getCountry() != null && locale.getCountry().length() == 2) {
            return Currency.getInstance(locale);
        }
        return Currency.getInstance("USD");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.amount = new BigDecimal(in.readFloat());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.amount.floatValue());
    }
}

