/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.email.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.email.dao.EmailReportingDao;
import org.broadleafcommerce.common.email.service.EmailTrackingManager;
import org.springframework.stereotype.Service;

@Service(value="blEmailTrackingManager")
public class EmailTrackingManagerImpl
implements EmailTrackingManager {
    private static final Log LOG = LogFactory.getLog(EmailTrackingManagerImpl.class);
    @Resource(name="blEmailReportingDao")
    protected EmailReportingDao emailReportingDao;

    @Override
    public Long createTrackedEmail(String emailAddress, String type, String extraValue) {
        return this.emailReportingDao.createTracking(emailAddress, type, extraValue);
    }

    @Override
    public void recordClick(Long emailId, Map<String, String> parameterMap, String customerId, Map<String, String> extraValues) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("recordClick() => Click detected for Email[" + emailId + "]"));
        }
        Iterator<String> keys = parameterMap.keySet().iterator();
        ArrayList<String> queryParms = new ArrayList<String>();
        while (keys.hasNext()) {
            String p = keys.next();
            if (p.equals("email_id")) continue;
            queryParms.add(p);
        }
        String newQuery = null;
        if (!queryParms.isEmpty()) {
            Object[] p = queryParms.toArray(new String[queryParms.size()]);
            Arrays.sort(p);
            StringBuffer newQueryParms = new StringBuffer();
            for (int cnt = 0; cnt < p.length; ++cnt) {
                newQueryParms.append((String)p[cnt]);
                newQueryParms.append("=");
                newQueryParms.append(parameterMap.get(p[cnt]));
                if (cnt == p.length - 1) continue;
                newQueryParms.append("&");
            }
            newQuery = newQueryParms.toString();
        }
        this.emailReportingDao.recordClick(emailId, customerId, extraValues.get("requestUri"), newQuery);
    }

    @Override
    public void recordOpen(Long emailId, Map<String, String> extraValues) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Recording open for email id: " + emailId));
        }
        this.emailReportingDao.recordOpen(emailId, extraValues.get("userAgent"));
    }
}

