/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor;

import java.util.ArrayList;
import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfoImpl;
import org.broadleafcommerce.pricing.service.module.CyberSourceTaxModule;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CountryImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.domain.StateImpl;
import org.broadleafcommerce.test.BaseTest;
import org.broadleafcommerce.vendor.cybersource.service.CyberSourceServiceManager;
import org.springframework.test.annotation.Rollback;
import org.testng.annotations.Test;

public class CyberSourceTaxModuleTest
extends BaseTest {
    @Resource
    private CyberSourceServiceManager serviceManager;

    @Test(groups={"testSuccessfulCyberSourceTaxModule"})
    @Rollback(value=false)
    public void testSuccessfulCyberSourceTaxModule() throws Exception {
        if (this.serviceManager.getMerchantId().equals("?")) {
            return;
        }
        CyberSourceTaxModule module = new CyberSourceTaxModule();
        module.setServiceManager(this.serviceManager);
        ArrayList<String> nexus = new ArrayList<String>();
        nexus.add("TX");
        module.setNexus(nexus);
        module.setOrderAcceptanceCity("Dallas");
        module.setOrderAcceptanceCountry("US");
        module.setOrderAcceptancePostalCode("75244");
        module.setOrderAcceptanceState("TX");
        PaymentInfo paymentInfo = this.createPaymentInfo("8335 Westchester Drive", "Dallas", "US", "John", "Test", "75225", "TX");
        OrderImpl order = new OrderImpl();
        order.setEmailAddress("null@cybersource.com");
        paymentInfo.setOrder((Order)order);
        order.getPaymentInfos().add(paymentInfo);
        DiscreteOrderItemImpl item1 = new DiscreteOrderItemImpl();
        SkuImpl sku1 = new SkuImpl();
        sku1.setName("a72345b");
        sku1.setDescription("Test Description Product 1");
        sku1.setTaxable(Boolean.valueOf(true));
        item1.setSku((Sku)sku1);
        item1.setPrice(new Money(10.0));
        FulfillmentGroupImpl fg1 = new FulfillmentGroupImpl();
        fg1.setId(Long.valueOf(1L));
        FulfillmentGroupItemImpl fgi1 = new FulfillmentGroupItemImpl();
        fgi1.setOrderItem((OrderItem)item1);
        fgi1.setQuantity(2);
        fg1.addFulfillmentGroupItem((FulfillmentGroupItem)fgi1);
        fg1.setAddress(this.createDestinationAddress("14930 Midway Rd", "Dallas", "US", "John", "Test", "75001", "TX"));
        order.getFulfillmentGroups().add(fg1);
        DiscreteOrderItemImpl item2 = new DiscreteOrderItemImpl();
        SkuImpl sku2 = new SkuImpl();
        sku2.setName("a72345c");
        sku2.setDescription("Test Description Product 2");
        sku2.setTaxable(Boolean.valueOf(true));
        item2.setSku((Sku)sku2);
        item2.setPrice(new Money(30.0));
        FulfillmentGroupImpl fg2 = new FulfillmentGroupImpl();
        fg2.setId(Long.valueOf(2L));
        FulfillmentGroupItemImpl fgi2 = new FulfillmentGroupItemImpl();
        fgi2.setOrderItem((OrderItem)item2);
        fgi2.setQuantity(1);
        fg2.addFulfillmentGroupItem((FulfillmentGroupItem)fgi2);
        fg2.setAddress(this.createDestinationAddress("14999 Monfort Drive", "Dallas", "US", "John", "Test", "75254", "TX"));
        order.getFulfillmentGroups().add(fg2);
        order.setTotal(new Money(50.0));
        assert (order.getTotalTax() == null);
        order = module.calculateTaxForOrder((Order)order);
        assert (order.getTotalTax() != null && order.getTotalTax().greaterThan(new Money(0.0)));
        assert (((FulfillmentGroup)order.getFulfillmentGroups().get(0)).getTotalTax().add(((FulfillmentGroup)order.getFulfillmentGroups().get(1)).getTotalTax()).equals((Object)order.getTotalTax()));
    }

    private PaymentInfo createPaymentInfo(String line1, String city, final String country, String name, String lastName, String postalCode, final String state) {
        PaymentInfoImpl paymentInfo = new PaymentInfoImpl();
        AddressImpl address = new AddressImpl();
        address.setAddressLine1(line1);
        address.setCity(city);
        address.setCountry((Country)new CountryImpl(){

            public String getAbbreviation() {
                return country;
            }
        });
        address.setFirstName(name);
        address.setLastName(lastName);
        address.setPostalCode(postalCode);
        address.setState((State)new StateImpl(){

            public String getAbbreviation() {
                return state;
            }
        });
        paymentInfo.setAddress((Address)address);
        paymentInfo.setCustomerIpAddress("10.7.111.111");
        return paymentInfo;
    }

    private Address createDestinationAddress(String line1, String city, final String country, String name, String lastName, String postalCode, final String state) {
        AddressImpl address = new AddressImpl();
        address.setAddressLine1(line1);
        address.setCity(city);
        address.setCountry((Country)new CountryImpl(){

            public String getAbbreviation() {
                return country;
            }
        });
        address.setFirstName(name);
        address.setLastName(lastName);
        address.setPostalCode(postalCode);
        address.setState((State)new StateImpl(){

            public String getAbbreviation() {
                return state;
            }
        });
        return address;
    }
}

