/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor;

import javax.annotation.Resource;
import org.broadleafcommerce.common.encryption.EncryptionModule;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfoImpl;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.PaymentContext;
import org.broadleafcommerce.core.payment.service.PaymentContextImpl;
import org.broadleafcommerce.payment.service.module.CyberSourceCreditCardModule;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CountryImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.domain.StateImpl;
import org.broadleafcommerce.test.BaseTest;
import org.broadleafcommerce.vendor.cybersource.service.CyberSourceServiceManager;
import org.springframework.test.annotation.Rollback;
import org.testng.annotations.Test;

public class CyberSourceCreditCardModuleTest
extends BaseTest {
    @Resource
    private CyberSourceServiceManager serviceManager;

    @Test(groups={"testSuccessfulCyberSourceCCModulePayment"})
    @Rollback(value=false)
    public void testSuccessfulCyberSourceCCModulePayment() throws Exception {
        if (this.serviceManager.getMerchantId().equals("?")) {
            return;
        }
        CyberSourceCreditCardModule module = new CyberSourceCreditCardModule();
        module.setServiceManager(this.serviceManager);
        Money amount = new Money(81.46);
        PaymentInfoImpl paymentInfo = new PaymentInfoImpl();
        paymentInfo.setAmount(amount);
        AddressImpl address = new AddressImpl();
        address.setAddressLine1("1295 Charleston Road");
        address.setCity("Mountain View");
        address.setCountry((Country)new CountryImpl(){

            public String getAbbreviation() {
                return "US";
            }
        });
        address.setFirstName("John");
        address.setLastName("Doe");
        address.setPostalCode("94043");
        address.setState((State)new StateImpl(){

            public String getAbbreviation() {
                return "CA";
            }
        });
        paymentInfo.setAddress((Address)address);
        paymentInfo.setCustomerIpAddress("10.7.111.111");
        OrderImpl order = new OrderImpl();
        order.setEmailAddress("null@cybersource.com");
        paymentInfo.setOrder((Order)order);
        Referenced referenced = this.createCreditCardPaymentInfo("4111111111111111", 12, 2020, null);
        PaymentContextImpl context = new PaymentContextImpl(amount, amount, (PaymentInfo)paymentInfo, referenced, "test");
        PaymentResponseItem responseItem = module.authorize((PaymentContext)context);
        assert (responseItem.getAmountPaid().equals((Object)amount));
        paymentInfo.getAdditionalFields().put("requestId", responseItem.getAdditionalFields().get("requestId"));
        paymentInfo.getAdditionalFields().put("requestToken", responseItem.getAdditionalFields().get("requestToken"));
        PaymentResponseItem responseItem2 = module.debit((PaymentContext)context);
        assert (responseItem2.getAmountPaid().equals((Object)amount));
        PaymentResponseItem responseItem3 = module.authorizeAndDebit((PaymentContext)context);
        assert (responseItem3.getAmountPaid().equals((Object)amount));
        paymentInfo.getAdditionalFields().put("requestId", responseItem3.getAdditionalFields().get("requestId"));
        paymentInfo.getAdditionalFields().put("requestToken", responseItem3.getAdditionalFields().get("requestToken"));
        PaymentResponseItem responseItem4 = module.credit((PaymentContext)context);
        assert (responseItem4.getAmountPaid().equals((Object)amount));
        PaymentResponseItem responseItem5 = module.authorize((PaymentContext)context);
        paymentInfo.getAdditionalFields().put("requestId", responseItem5.getAdditionalFields().get("requestId"));
        paymentInfo.getAdditionalFields().put("requestToken", responseItem5.getAdditionalFields().get("requestToken"));
        PaymentResponseItem responseItem6 = module.reverseAuthorize((PaymentContext)context);
        assert (responseItem6.getAmountPaid().equals((Object)amount));
    }

    private Referenced createCreditCardPaymentInfo(final String pan, final Integer month, final Integer year, final String cvv) {
        CreditCardPaymentInfo ccInfo = new CreditCardPaymentInfo(){

            public String getCvvCode() {
                return cvv;
            }

            public Integer getExpirationMonth() {
                return month;
            }

            public Integer getExpirationYear() {
                return year;
            }

            public Long getId() {
                return null;
            }

            public String getPan() {
                return pan;
            }

            public void setCvvCode(String cvvCode) {
            }

            public void setExpirationMonth(Integer expirationMonth) {
            }

            public void setExpirationYear(Integer expirationYear) {
            }

            public void setId(Long id) {
            }

            public void setPan(String pan2) {
            }

            public EncryptionModule getEncryptionModule() {
                return null;
            }

            public String getReferenceNumber() {
                return null;
            }

            public void setEncryptionModule(EncryptionModule encryptionModule) {
            }

            public void setReferenceNumber(String referenceNumber) {
            }
        };
        return ccInfo;
    }
}

