/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.service;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.CustomerAddressImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.service.CustomerAddressService;
import org.broadleafcommerce.profile.dataprovider.CustomerAddressDataProvider;
import org.broadleafcommerce.test.CommonSetupBaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class CustomerAddressTest
extends CommonSetupBaseTest {
    private String userName;
    private Long userId;
    @Resource
    private CustomerAddressService customerAddressService;

    @Test(groups={"testCustomerAddress"})
    @Transactional
    public void readCustomerAddresses() {
        Customer customer = this.createCustomerWithAddresses();
        List customerAddressList = this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId());
        for (CustomerAddress ca : customerAddressList) {
            assert (ca != null);
        }
    }

    @Test(groups={"testCustomerAddress"})
    @Transactional
    public void createNewDefaultAddress() {
        Customer customer = this.createCustomerWithAddresses();
        CustomerAddressImpl ca = new CustomerAddressImpl();
        AddressImpl address = new AddressImpl();
        address.setAddressLine1("123 Main");
        address.setCity("Dallas");
        address.setPostalCode("75201");
        address.setDefault(true);
        ca.setAddress((Address)address);
        ca.setCustomer(customer);
        ca.setAddressName("address3");
        CustomerAddress savedAddress = this.saveCustomerAddress((CustomerAddress)ca);
        List customerAddressList = this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId());
        for (CustomerAddress customerAddress : customerAddressList) {
            if (customerAddress.getId().equals(savedAddress.getId()) ? !$assertionsDisabled && !customerAddress.getAddress().isDefault() : !$assertionsDisabled && customerAddress.getAddress().isDefault()) {
                throw new AssertionError();
            }
        }
    }

    @Deprecated
    @Test(groups={"createCustomerAddress"}, dataProvider="setupCustomerAddress", dataProviderClass=CustomerAddressDataProvider.class, dependsOnGroups={"readCustomer", "createCountry", "createState"})
    @Transactional
    @Rollback(value=false)
    public void createCustomerAddress(CustomerAddress customerAddress) {
        this.userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(this.userName);
        assert (customerAddress.getId() == null);
        customerAddress.setCustomer(customer);
        State state = this.stateService.findStateByAbbreviation("KY");
        customerAddress.getAddress().setState(state);
        Country country = this.countryService.findCountryByAbbreviation("US");
        customerAddress.getAddress().setCountry(country);
        customerAddress = this.customerAddressService.saveCustomerAddress(customerAddress);
        assert (customer.equals(customerAddress.getCustomer()));
        this.userId = customerAddress.getCustomer().getId();
    }

    @Deprecated
    @Test(groups={"readCustomerAddress"}, dependsOnGroups={"createCustomerAddress"})
    @Transactional
    public void readCustomerAddressByUserId() {
        List customerAddressList = this.customerAddressService.readActiveCustomerAddressesByCustomerId(this.userId);
        for (CustomerAddress customerAddress : customerAddressList) {
            assert (customerAddress != null);
        }
    }
}

