/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor;

import java.util.Currency;
import java.util.Locale;
import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.test.BaseTest;
import org.broadleafcommerce.vendor.cybersource.service.CyberSourceServiceManager;
import org.broadleafcommerce.vendor.cybersource.service.message.CyberSourceBillingRequest;
import org.broadleafcommerce.vendor.cybersource.service.message.CyberSourceItemRequest;
import org.broadleafcommerce.vendor.cybersource.service.message.CyberSourceRequest;
import org.broadleafcommerce.vendor.cybersource.service.payment.CyberSourcePaymentService;
import org.broadleafcommerce.vendor.cybersource.service.payment.message.CyberSourceCardRequest;
import org.broadleafcommerce.vendor.cybersource.service.payment.message.CyberSourceCardResponse;
import org.broadleafcommerce.vendor.cybersource.service.payment.message.CyberSourcePaymentRequest;
import org.broadleafcommerce.vendor.cybersource.service.payment.type.CyberSourceTransactionType;
import org.springframework.test.annotation.Rollback;
import org.testng.annotations.Test;

public class CyberSourcePaymentServiceTest
extends BaseTest {
    @Resource
    private CyberSourceServiceManager serviceManager;

    @Test(groups={"testSuccessfulCyberSourceCCPayment"})
    @Rollback(value=false)
    public void testSuccessfulCyberSourceCCPayment() throws Exception {
        if (this.serviceManager.getMerchantId().equals("?")) {
            return;
        }
        CyberSourceCardRequest cardRequest = new CyberSourceCardRequest();
        cardRequest.setTransactionType(CyberSourceTransactionType.AUTHORIZE);
        cardRequest.setCurrency(Currency.getInstance(Locale.US).getCurrencyCode());
        CyberSourceBillingRequest billingRequest = new CyberSourceBillingRequest();
        billingRequest.setCity("Mountain View");
        billingRequest.setFirstName("John");
        billingRequest.setLastName("Doe");
        billingRequest.setPostalCode("94043");
        billingRequest.setIpAddress("10.7.111.111");
        billingRequest.setState("CA");
        billingRequest.setStreet1("1295 Charleston Road");
        billingRequest.setCountry("US");
        billingRequest.setEmail("null@cybersource.com");
        cardRequest.setBillingRequest(billingRequest);
        CyberSourceItemRequest itemRequest1 = new CyberSourceItemRequest();
        itemRequest1.setDescription("First Item");
        itemRequest1.setQuantity(Long.valueOf(2L));
        itemRequest1.setShortDescription("firstItem");
        itemRequest1.setUnitPrice(new Money(12.34));
        cardRequest.getItemRequests().add(itemRequest1);
        CyberSourceItemRequest itemRequest2 = new CyberSourceItemRequest();
        itemRequest2.setDescription("Second Item");
        itemRequest2.setQuantity(Long.valueOf(1L));
        itemRequest2.setShortDescription("secondItem");
        itemRequest2.setUnitPrice(new Money(56.78));
        cardRequest.getItemRequests().add(itemRequest2);
        cardRequest.setAccountNumber("4111111111111111");
        cardRequest.setExpirationMonth(Integer.valueOf(12));
        cardRequest.setExpirationYear(Integer.valueOf(2020));
        CyberSourcePaymentService service = (CyberSourcePaymentService)this.serviceManager.getValidService((CyberSourceRequest)cardRequest);
        CyberSourceCardResponse response = (CyberSourceCardResponse)service.process((CyberSourcePaymentRequest)cardRequest);
        assert (response.getAuthResponse().getAmount().doubleValue() > 0.0);
        assert (response.getReasonCode() == 100);
        CyberSourceCardRequest cardRequest2 = new CyberSourceCardRequest();
        cardRequest2.setTransactionType(CyberSourceTransactionType.CAPTURE);
        cardRequest2.setCurrency(Currency.getInstance(Locale.US).getCurrencyCode());
        cardRequest2.setRequestID(response.getRequestID());
        cardRequest2.setRequestToken(response.getRequestToken());
        cardRequest2.getItemRequests().add(itemRequest1);
        cardRequest2.getItemRequests().add(itemRequest2);
        CyberSourceCardResponse response2 = (CyberSourceCardResponse)service.process((CyberSourcePaymentRequest)cardRequest2);
        assert (response2.getReasonCode() == 100);
        cardRequest.setTransactionType(CyberSourceTransactionType.AUTHORIZEANDCAPTURE);
        CyberSourceCardResponse response3 = (CyberSourceCardResponse)service.process((CyberSourcePaymentRequest)cardRequest);
        assert (response3.getAuthResponse().getAmount().doubleValue() > 0.0);
        assert (response3.getCaptureResponse().getAmount().doubleValue() > 0.0);
        assert (response3.getReasonCode() == 100);
        CyberSourceCardRequest cardRequest4 = new CyberSourceCardRequest();
        cardRequest4.setTransactionType(CyberSourceTransactionType.CREDIT);
        cardRequest4.setCurrency(Currency.getInstance(Locale.US).getCurrencyCode());
        cardRequest4.setRequestID(response3.getRequestID());
        cardRequest4.setRequestToken(response3.getRequestToken());
        cardRequest4.getItemRequests().add(itemRequest1);
        cardRequest4.getItemRequests().add(itemRequest2);
        CyberSourceCardResponse response4 = (CyberSourceCardResponse)service.process((CyberSourcePaymentRequest)cardRequest4);
        assert (response4.getReasonCode() == 100);
        cardRequest.setTransactionType(CyberSourceTransactionType.AUTHORIZE);
        CyberSourceCardResponse response7 = (CyberSourceCardResponse)service.process((CyberSourcePaymentRequest)cardRequest);
        CyberSourceCardRequest cardRequest7 = new CyberSourceCardRequest();
        cardRequest7.setTransactionType(CyberSourceTransactionType.REVERSEAUTHORIZE);
        cardRequest7.setCurrency(Currency.getInstance(Locale.US).getCurrencyCode());
        cardRequest7.setRequestID(response7.getRequestID());
        cardRequest7.setRequestToken(response7.getRequestToken());
        cardRequest7.getItemRequests().add(itemRequest1);
        cardRequest7.getItemRequests().add(itemRequest2);
        CyberSourceCardResponse response8 = (CyberSourceCardResponse)service.process((CyberSourcePaymentRequest)cardRequest7);
        assert (response8.getReasonCode() == 100);
    }
}

