/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.inventory.service;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.inventory.domain.SkuAvailability;
import org.broadleafcommerce.core.inventory.service.AvailabilityService;
import org.broadleafcommerce.core.inventory.service.dataprovider.SkuAvailabilityDataProvider;
import org.broadleafcommerce.core.inventory.service.type.AvailabilityStatusType;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.testng.annotations.Test;

public class SkuAvailabilityTest
extends BaseTest {
    protected final Long[] skuIDs = new Long[]{1L, 2L, 3L, 4L, 5L};
    protected final List<Long> skuIdList = Arrays.asList(this.skuIDs);
    @Resource
    private AvailabilityService availabilityService;

    @Test(groups={"createSkuAvailability"}, dataProvider="setupSkuAvailability", dataProviderClass=SkuAvailabilityDataProvider.class)
    @Rollback(value=false)
    public void createSkuAvailability(SkuAvailability skuAvailability) {
        this.availabilityService.save(skuAvailability);
    }

    @Test(dependsOnGroups={"createSkuAvailability"})
    public void readSKUAvailabilityEntries() {
        List skuAvailabilityList = this.availabilityService.lookupSKUAvailability(this.skuIdList, false);
        assert (skuAvailabilityList.size() == 5);
        int backorderCount = 0;
        int availableCount = 0;
        for (SkuAvailability skuAvailability : skuAvailabilityList) {
            if (skuAvailability.getAvailabilityStatus() != null && skuAvailability.getAvailabilityStatus().equals((Object)AvailabilityStatusType.BACKORDERED)) {
                ++backorderCount;
            }
            if (skuAvailability.getAvailabilityStatus() == null || !skuAvailability.getAvailabilityStatus().equals((Object)AvailabilityStatusType.AVAILABLE)) continue;
            ++availableCount;
        }
        assert (backorderCount == 1);
        assert (availableCount == 1);
    }

    @Test(dependsOnGroups={"createSkuAvailability"})
    public void readAvailableSkusForUnknownLocation() {
        List skuAvailabilityList = this.availabilityService.lookupSKUAvailabilityForLocation(this.skuIdList, Long.valueOf(100L), false);
        assert (skuAvailabilityList.size() == 0);
    }

    @Test(dependsOnGroups={"createSkuAvailability"})
    public void readAvailableSkusForLocation() {
        List skuAvailabilityList = this.availabilityService.lookupSKUAvailabilityForLocation(this.skuIdList, Long.valueOf(1L), false);
        assert (skuAvailabilityList.size() == 5);
    }

    @Test(dependsOnGroups={"createSkuAvailability"})
    public void checkAvailableQuantityWithReserveAndQOH() {
        SkuAvailability skuAvailability = this.availabilityService.lookupSKUAvailabilityForLocation(Long.valueOf(2L), Long.valueOf(1L), false);
        assert (skuAvailability.getReserveQuantity() == 1 && skuAvailability.getQuantityOnHand() == 5);
        assert (skuAvailability.getAvailableQuantity() == 4);
    }

    @Test(dependsOnGroups={"createSkuAvailability"})
    public void checkAvailableQuantityWithNullReserveQty() {
        SkuAvailability skuAvailability = this.availabilityService.lookupSKUAvailabilityForLocation(Long.valueOf(5L), Long.valueOf(1L), false);
        assert (skuAvailability.getReserveQuantity() == null && skuAvailability.getQuantityOnHand() == 5);
        assert (skuAvailability.getAvailableQuantity() == 5);
    }

    @Test(dependsOnGroups={"createSkuAvailability"})
    public void checkAvailableQuantityWithNullQuantityOnHand() {
        SkuAvailability skuAvailability = this.availabilityService.lookupSKUAvailabilityForLocation(Long.valueOf(1L), Long.valueOf(1L), false);
        assert (skuAvailability.getReserveQuantity() == 1 && skuAvailability.getQuantityOnHand() == null);
        assert (skuAvailability.getAvailableQuantity() == null);
    }
}

