/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor;

import java.math.BigDecimal;
import javax.annotation.Resource;
import org.broadleafcommerce.common.util.UnitOfMeasureUtil;
import org.broadleafcommerce.common.util.WeightUnitOfMeasureType;
import org.broadleafcommerce.test.BaseTest;
import org.broadleafcommerce.vendor.usps.service.USPSShippingCalculationService;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItem;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItemResponse;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceResponse;
import org.broadleafcommerce.vendor.usps.service.type.USPSContainerShapeType;
import org.broadleafcommerce.vendor.usps.service.type.USPSContainerSizeType;
import org.broadleafcommerce.vendor.usps.service.type.USPSServiceType;
import org.springframework.test.annotation.Rollback;
import org.testng.annotations.Test;

public class USPSShippingServiceTest
extends BaseTest {
    @Resource
    private USPSShippingCalculationService shippingCalculationService;

    @Test(groups={"testSuccessfulShippingCalc"})
    @Rollback(value=false)
    public void testSuccessfulShippingCalc() throws Exception {
        if (this.shippingCalculationService.getUspsUserName().equals("?")) {
            return;
        }
        USPSShippingPriceRequest request = new USPSShippingPriceRequest();
        USPSContainerItem itemRequest = new USPSContainerItem();
        itemRequest.setService(USPSServiceType.ALL);
        itemRequest.setContainerSize(USPSContainerSizeType.LARGE);
        itemRequest.setPackageId("0");
        itemRequest.setWeight(BigDecimal.valueOf(10L).add(UnitOfMeasureUtil.convertOuncesToPounds((BigDecimal)BigDecimal.valueOf(5L))));
        itemRequest.setWeightUnitOfMeasureType(WeightUnitOfMeasureType.POUNDS);
        itemRequest.setZipDestination("20008");
        itemRequest.setZipOrigination("10022");
        itemRequest.setMachineSortable(Boolean.valueOf(true));
        request.getContainerItems().add(itemRequest);
        USPSShippingPriceResponse response = this.shippingCalculationService.retrieveShippingRates(request);
        assert (((USPSContainerItemResponse)response.getResponses().peek()).getPostage().size() > 0);
        USPSShippingPriceRequest request2 = new USPSShippingPriceRequest();
        USPSContainerItem itemRequest2 = new USPSContainerItem();
        itemRequest2.setService(USPSServiceType.PRIORITY);
        itemRequest2.setContainerSize(USPSContainerSizeType.REGULAR);
        itemRequest2.setContainerShape(USPSContainerShapeType.FLATRATEBOX);
        itemRequest2.setPackageId("0");
        itemRequest2.setWeight(BigDecimal.valueOf(10L).add(UnitOfMeasureUtil.convertOuncesToPounds((BigDecimal)BigDecimal.valueOf(5L))));
        itemRequest2.setWeightUnitOfMeasureType(WeightUnitOfMeasureType.POUNDS);
        itemRequest2.setZipDestination("20008");
        itemRequest2.setZipOrigination("10022");
        request2.getContainerItems().add(itemRequest2);
        USPSShippingPriceResponse response2 = this.shippingCalculationService.retrieveShippingRates(request2);
        assert (((USPSContainerItemResponse)response2.getResponses().peek()).getPostage().size() > 0);
    }
}

