/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor;

import java.math.BigDecimal;
import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.util.UnitOfMeasureUtil;
import org.broadleafcommerce.common.util.WeightUnitOfMeasureType;
import org.broadleafcommerce.common.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.common.vendor.service.type.ContainerSizeType;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.ProductWeight;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.pricing.service.workflow.type.ShippingServiceType;
import org.broadleafcommerce.order.service.type.USPSServiceMethod;
import org.broadleafcommerce.pricing.service.module.USPSShippingCalculationModule;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.test.BaseTest;
import org.broadleafcommerce.vendor.usps.service.USPSShippingCalculationService;
import org.broadleafcommerce.vendor.usps.service.type.USPSContainerShapeType;
import org.broadleafcommerce.vendor.usps.service.type.USPSContainerSizeType;
import org.springframework.test.annotation.Rollback;
import org.testng.annotations.Test;

public class USPSShippingCalculationModuleTest
extends BaseTest {
    @Resource
    private USPSShippingCalculationService shippingCalculationService;
    @Resource
    private USPSShippingCalculationModule shippingCalculationModule;

    @Test(groups={"testSuccessfulShippingModuleCalc"})
    @Rollback(value=false)
    public void testSuccessfulShippingModuleCalc() throws Exception {
        if (this.shippingCalculationService.getUspsUserName().equals("?")) {
            return;
        }
        FulfillmentGroupImpl fg = new FulfillmentGroupImpl();
        fg.setService(ShippingServiceType.USPS.getType());
        fg.setMethod(USPSServiceMethod.PRIORITYMAIL.getType());
        DiscreteOrderItemImpl dsItem1 = new DiscreteOrderItemImpl();
        ProductImpl product1 = new ProductImpl();
        product1.setSize((ContainerSizeType)USPSContainerSizeType.REGULAR);
        product1.setContainer((ContainerShapeType)USPSContainerShapeType.FLATRATEBOX);
        ProductWeight weight = new ProductWeight();
        weight.setWeight(BigDecimal.valueOf(10L).add(UnitOfMeasureUtil.convertOuncesToPounds((BigDecimal)BigDecimal.valueOf(5L))));
        weight.setWeightUnitOfMeasure(WeightUnitOfMeasureType.POUNDS);
        product1.setWeight(weight);
        dsItem1.setProduct((Product)product1);
        AddressImpl address = new AddressImpl();
        address.setPostalCode("20008");
        fg.setAddress((Address)address);
        FulfillmentGroupItemImpl fgItem = new FulfillmentGroupItemImpl();
        fgItem.setOrderItem((OrderItem)dsItem1);
        fg.getFulfillmentGroupItems().add(fgItem);
        FulfillmentGroup response = this.shippingCalculationModule.calculateShippingForFulfillmentGroup((FulfillmentGroup)fg);
        assert (response.getShippingPrice().greaterThan(new Money(0.0)));
    }
}

