/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.email.service;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.email.service.EmailService;
import org.broadleafcommerce.profile.email.service.info.EmailInfo;
import org.broadleafcommerce.test.BaseTest;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class EmailTest
extends BaseTest {
    @Resource
    EmailService emailService;
    private GreenMail greenMail;

    @BeforeClass
    protected void setupEmailTest() {
        this.greenMail = new GreenMail(new ServerSetup[]{new ServerSetup(30000, "127.0.0.1", "smtp")});
        this.greenMail.start();
    }

    @AfterClass
    protected void tearDownEmailTest() {
        this.greenMail.stop();
    }

    @Test
    public void testSynchronousEmail() throws Exception {
        EmailInfo info = new EmailInfo();
        info.setFromAddress("me@test.com");
        info.setSubject("test");
        info.setEmailTemplate("org/broadleafcommerce/profile/email/service/template/default.vm");
        info.setSendEmailReliableAsync("false");
        this.emailService.sendTemplateEmail("to@localhost", info, null);
        assert (this.greenMail.waitForIncomingEmail(10000L, 1));
    }
}

