/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.domain.OfferCodeImpl;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.type.OfferDeliveryType;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.pricing.ShippingRateDataProvider;
import org.broadleafcommerce.core.pricing.domain.ShippingRate;
import org.broadleafcommerce.core.pricing.service.ShippingRateService;
import org.broadleafcommerce.core.pricing.service.workflow.type.ShippingServiceType;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CountryImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.IdGenerationImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.domain.StateImpl;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.broadleafcommerce.profile.time.SystemTime;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class PricingTest
extends BaseTest {
    @Resource
    private CustomerService customerService;
    @Resource
    private CartService cartService;
    @Resource
    private ShippingRateService shippingRateService;
    @Resource
    private CatalogService catalogService;
    @Resource
    private OrderItemService orderItemService;
    @Resource
    private OfferService offerService;
    @Resource
    private CountryService countryService;
    @Resource
    private StateService stateService;

    @Test(groups={"testShippingInsert"}, dataProvider="basicShippingRates", dataProviderClass=ShippingRateDataProvider.class)
    @Rollback(value=false)
    public void testShippingInsert(ShippingRate shippingRate, ShippingRate sr2) throws Exception {
        shippingRate = this.shippingRateService.save(shippingRate);
        sr2 = this.shippingRateService.save(sr2);
    }

    @Test(dependsOnGroups={"testShippingInsert", "createCustomerIdGeneration"})
    @Transactional
    public void testPricing() throws Exception {
        Order order = this.cartService.createNewCartForCustomer(this.createCustomer());
        this.customerService.saveCustomer(order.getCustomer());
        AddressImpl address = new AddressImpl();
        address.setAddressLine1("123 Test Rd");
        address.setCity("Dallas");
        address.setFirstName("Jeff");
        address.setLastName("Fischer");
        address.setPostalCode("75240");
        address.setPrimaryPhone("972-978-9067");
        StateImpl state = new StateImpl();
        state.setAbbreviation("ALL");
        state.setName("ALL");
        address.setState((State)state);
        CountryImpl country = new CountryImpl();
        country.setAbbreviation("US");
        country.setName("United States");
        state.setCountry((Country)country);
        address.setCountry((Country)country);
        FulfillmentGroupImpl group = new FulfillmentGroupImpl();
        group.setAddress((Address)address);
        group.setIsShippingPriceTaxable(Boolean.valueOf(true));
        ArrayList<FulfillmentGroupImpl> groups = new ArrayList<FulfillmentGroupImpl>();
        group.setMethod("standard");
        group.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        group.setOrder(order);
        groups.add(group);
        order.setFulfillmentGroups(groups);
        Money total = new Money(8.5);
        group.setShippingPrice(total);
        DiscreteOrderItemImpl item = new DiscreteOrderItemImpl();
        SkuImpl sku = new SkuImpl();
        sku.setName("Test Sku");
        sku.setRetailPrice(new Money(10.0));
        sku.setDiscountable(Boolean.valueOf(true));
        sku = this.catalogService.saveSku((Sku)sku);
        item.setSku((Sku)sku);
        item.setQuantity(2);
        item.setOrder(order);
        item = (DiscreteOrderItem)this.orderItemService.saveOrderItem((OrderItem)item);
        order.addOrderItem((OrderItem)item);
        FulfillmentGroupItemImpl fgItem = new FulfillmentGroupItemImpl();
        fgItem.setFulfillmentGroup((FulfillmentGroup)group);
        fgItem.setOrderItem((OrderItem)item);
        fgItem.setQuantity(2);
        group.addFulfillmentGroupItem((FulfillmentGroupItem)fgItem);
        item = new DiscreteOrderItemImpl();
        sku = new SkuImpl();
        sku.setName("Test Product 2");
        sku.setRetailPrice(new Money(20.0));
        sku.setDiscountable(Boolean.valueOf(true));
        sku = this.catalogService.saveSku((Sku)sku);
        item.setSku((Sku)sku);
        item.setQuantity(1);
        item.setOrder(order);
        item = (DiscreteOrderItem)this.orderItemService.saveOrderItem((OrderItem)item);
        order.addOrderItem((OrderItem)item);
        fgItem = new FulfillmentGroupItemImpl();
        fgItem.setFulfillmentGroup((FulfillmentGroup)group);
        fgItem.setOrderItem((OrderItem)item);
        fgItem.setQuantity(1);
        group.addFulfillmentGroupItem((FulfillmentGroupItem)fgItem);
        order.addOfferCode(this.createOfferCode("20 Percent Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.PERCENT_OFF, 20.0, null, "discreteOrderItem.sku.name==\"Test Sku\""));
        order.addOfferCode(this.createOfferCode("3 Dollars Off Item Offer", OfferType.ORDER_ITEM, OfferDiscountType.AMOUNT_OFF, 3.0, null, "discreteOrderItem.sku.name!=\"Test Sku\""));
        order.addOfferCode(this.createOfferCode("1.20 Dollars Off Order Offer", OfferType.ORDER, OfferDiscountType.AMOUNT_OFF, 1.2, null, null));
        order.setTotalShipping(new Money(0.0));
        this.cartService.save(order, Boolean.valueOf(true));
        assert (order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(31.8)));
        assert (order.getTotal().greaterThan(order.getSubTotal()));
        assert (order.getTotalTax().equals((Object)order.getSubTotal().multiply(0.05).add(group.getShippingPrice().multiply(0.05))));
        assert (order.getTotal().equals((Object)order.getSubTotal().add(order.getTotalTax()).add(order.getTotalShipping()).subtract(order.getOrderAdjustmentsValue())));
    }

    @Test(groups={"testShipping"}, dependsOnGroups={"testShippingInsert", "createCustomerIdGeneration"})
    @Transactional
    public void testShipping() throws Exception {
        Order order = this.cartService.createNewCartForCustomer(this.createCustomer());
        this.customerService.saveCustomer(order.getCustomer());
        FulfillmentGroupImpl group1 = new FulfillmentGroupImpl();
        FulfillmentGroupImpl group2 = new FulfillmentGroupImpl();
        group1.setMethod("standard");
        group1.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        AddressImpl address = new AddressImpl();
        address.setAddressLine1("123 Test Rd");
        address.setCity("Dallas");
        address.setFirstName("Jeff");
        address.setLastName("Fischer");
        address.setPostalCode("75240");
        address.setPrimaryPhone("972-978-9067");
        CountryImpl country = new CountryImpl();
        country.setAbbreviation("US");
        country.setName("United States");
        this.countryService.save((Country)country);
        StateImpl state = new StateImpl();
        state.setAbbreviation("TX");
        state.setName("Texas");
        state.setCountry((Country)country);
        this.stateService.save((State)state);
        address.setState((State)state);
        address.setCountry((Country)country);
        group1.setAddress((Address)address);
        group1.setOrder(order);
        group1.setIsShippingPriceTaxable(Boolean.valueOf(true));
        group2.setMethod("truck");
        group2.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        group2.setOrder(order);
        ArrayList<FulfillmentGroupImpl> groups = new ArrayList<FulfillmentGroupImpl>();
        groups.add(group1);
        order.setFulfillmentGroups(groups);
        Money total = new Money(8.5);
        group1.setShippingPrice(total);
        group2.setShippingPrice(total);
        order.setSubTotal(total);
        order.setTotal(total);
        DiscreteOrderItemImpl item = new DiscreteOrderItemImpl();
        item.setPrice(new Money(10.0));
        item.setRetailPrice(new Money(15.0));
        SkuImpl sku = new SkuImpl();
        sku.setRetailPrice(new Money(15.0));
        sku.setDiscountable(Boolean.valueOf(true));
        sku.setName("Test Sku");
        sku = this.catalogService.saveSku((Sku)sku);
        item.setSku((Sku)sku);
        item.setQuantity(1);
        item.setOrder(order);
        item = (DiscreteOrderItem)this.orderItemService.saveOrderItem((OrderItem)item);
        ArrayList<DiscreteOrderItemImpl> items = new ArrayList<DiscreteOrderItemImpl>();
        items.add(item);
        order.setOrderItems(items);
        for (OrderItem orderItem : items) {
            FulfillmentGroupItemImpl fgi = new FulfillmentGroupItemImpl();
            fgi.setOrderItem(orderItem);
            fgi.setFulfillmentGroup((FulfillmentGroup)group1);
            group1.addFulfillmentGroupItem((FulfillmentGroupItem)fgi);
        }
        order.setTotalShipping(new Money(0.0));
        this.cartService.save(order, Boolean.valueOf(true));
        assert (order.getTotal().greaterThan(order.getSubTotal()));
        assert (order.getTotalTax().equals((Object)order.getSubTotal().multiply(0.05).add(group1.getShippingPrice().multiply(0.05))));
        assert (order.getTotal().equals((Object)order.getSubTotal().add(order.getTotalTax().add(order.getTotalShipping()))));
    }

    @Test(groups={"createCustomerIdGeneration"})
    @Rollback(value=false)
    public void createCustomerIdGeneration() {
        IdGenerationImpl idGeneration = new IdGenerationImpl();
        idGeneration.setType("org.broadleafcommerce.profile.core.domain.Customer");
        idGeneration.setBatchStart(Long.valueOf(1L));
        idGeneration.setBatchSize(Long.valueOf(10L));
        this.em.persist((Object)idGeneration);
    }

    public Customer createCustomer() {
        Customer customer = this.customerService.createCustomerFromId(null);
        return customer;
    }

    private OfferCode createOfferCode(String offerName, OfferType offerType, OfferDiscountType discountType, double value, String customerRule, String orderRule) {
        OfferCodeImpl offerCode = new OfferCodeImpl();
        Offer offer = this.createOffer(offerName, offerType, discountType, value, customerRule, orderRule);
        offerCode.setOffer(offer);
        offerCode.setOfferCode("OPRAH");
        offerCode = this.offerService.saveOfferCode((OfferCode)offerCode);
        return offerCode;
    }

    private Offer createOffer(String offerName, OfferType offerType, OfferDiscountType discountType, double value, String customerRule, String orderRule) {
        OfferImpl offer = new OfferImpl();
        offer.setName(offerName);
        offer.setStartDate(SystemTime.asDate());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        offer.setStartDate(calendar.getTime());
        calendar.add(5, 2);
        offer.setEndDate(calendar.getTime());
        offer.setType(offerType);
        offer.setDiscountType(discountType);
        offer.setValue(BigDecimal.valueOf(value));
        offer.setDeliveryType(OfferDeliveryType.CODE);
        offer.setStackable(true);
        offer.setAppliesToOrderRules(orderRule);
        offer.setAppliesToCustomerRules(customerRule);
        offer.setCombinableWithOtherOffers(true);
        offer = this.offerService.save((Offer)offer);
        offer.setMaxUses(50);
        return offer;
    }
}

