/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.media.domain.MediaImpl;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class CatalogTest
extends BaseTest {
    @Resource
    private CatalogService catalogService;
    @Resource
    private ProductDao productDao;

    @Test
    @Transactional
    public void testCatalog() throws Exception {
        CategoryImpl category = new CategoryImpl();
        category.setName("Soaps");
        category = this.catalogService.saveCategory((Category)category);
        CategoryImpl category2 = new CategoryImpl();
        category2.setName("Towels");
        category2 = this.catalogService.saveCategory((Category)category2);
        CategoryImpl category3 = new CategoryImpl();
        category3.setName("SuperCategory");
        category3.getAllParentCategories().add(category);
        category3 = this.catalogService.saveCategory((Category)category3);
        Long cat3Id = category3.getId();
        category3 = null;
        category3 = this.catalogService.findCategoryById(cat3Id);
        category3.getAllParentCategories().clear();
        category3.getAllParentCategories().add(category);
        category3.getAllParentCategories().add(category2);
        category3 = this.catalogService.saveCategory((Category)category3);
        assert (category3.getAllParentCategories().size() == 2);
        ProductImpl newProduct = new ProductImpl();
        Calendar activeStartCal = Calendar.getInstance();
        activeStartCal.add(6, -2);
        newProduct.setActiveStartDate(activeStartCal.getTime());
        newProduct.setDefaultCategory((Category)category);
        newProduct.getAllParentCategories().clear();
        newProduct.getAllParentCategories().add(category);
        newProduct.getAllParentCategories().add(category2);
        newProduct.setName("Lavender Soap");
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        Long newProductId = newProduct.getId();
        Product testProduct = this.catalogService.findProductById(newProductId);
        assert (testProduct.getId().equals(testProduct.getId()));
        Category testCategory = this.catalogService.findCategoryByName("Soaps");
        assert (testCategory.getId().equals(category.getId()));
        testCategory = this.catalogService.findCategoryById(category.getId());
        assert (testCategory.getId().equals(category.getId()));
        Map categoryMedia = testCategory.getCategoryMedia();
        MediaImpl media = new MediaImpl();
        media.setLabel("test");
        media.setName("large");
        media.setUrl("http://myUrl");
        categoryMedia.put("large", media);
        this.catalogService.saveCategory(testCategory);
        testCategory = this.catalogService.findCategoryById(category.getId());
        assert (testCategory.getCategoryMedia().get("large") != null);
        List categories = this.catalogService.findAllCategories();
        assert (categories != null && categories.size() == 3);
        List products = this.catalogService.findAllProducts();
        boolean foundProduct = false;
        for (Product product : products) {
            if (!product.getId().equals(newProductId)) continue;
            foundProduct = true;
        }
        assert (foundProduct);
        products = this.catalogService.findProductsByName(newProduct.getName());
        foundProduct = false;
        for (Product product : products) {
            if (!product.getId().equals(newProductId)) continue;
            foundProduct = true;
        }
        assert (foundProduct);
        SkuImpl newSku = new SkuImpl();
        newSku.setName("Under Armor T-Shirt -- Red");
        newSku.setRetailPrice(new Money(14.99));
        newSku.setActiveStartDate(activeStartCal.getTime());
        newSku = this.catalogService.saveSku((Sku)newSku);
        ArrayList<SkuImpl> allSkus = new ArrayList<SkuImpl>();
        allSkus.add(newSku);
        newProduct.setAllSkus(allSkus);
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        Long skuId = ((Sku)newProduct.getSkus().get(0)).getId();
        Sku testSku = this.catalogService.findSkuById(skuId);
        assert (testSku.getId().equals(skuId));
        List testSkus = this.catalogService.findAllSkus();
        boolean foundSku = false;
        for (Sku sku : testSkus) {
            if (!sku.getId().equals(skuId)) continue;
            foundSku = true;
        }
        assert (foundSku);
        ArrayList<Long> skuIds = new ArrayList<Long>();
        skuIds.add(skuId);
        testSkus = this.catalogService.findSkusByIds(skuIds);
        foundSku = false;
        for (Sku sku : testSkus) {
            if (!sku.getId().equals(skuId)) continue;
            foundSku = true;
        }
        assert (foundSku);
        foundProduct = false;
        List findProducts = this.productDao.readProductsBySku(((Sku)newProduct.getSkus().get(0)).getId());
        for (Product findProduct : findProducts) {
            if (!findProduct.getId().equals(newProduct.getId())) continue;
            foundProduct = true;
        }
        assert (foundProduct);
    }

    @Test
    public void testSkus() throws Exception {
        SkuImpl sku = new SkuImpl();
        String longDescription = "This is a great product that will help the Longhorns win.";
        String description = "This is a great product.";
        sku.setLongDescription(longDescription);
        assert (sku.getLongDescription().equals(longDescription));
        sku.setDescription(description);
        assert (sku.getDescription().equals(description));
        assert (sku.isTaxable() == null);
        sku.setTaxable(null);
        assert (sku.isTaxable() == null);
        sku.setTaxable(Boolean.valueOf(true));
        assert (sku.isTaxable().booleanValue());
        sku.setTaxable(Boolean.valueOf(false));
        assert (!sku.isTaxable().booleanValue());
        assert (sku.isDiscountable() == null);
        sku.setDiscountable(null);
        assert (sku.isDiscountable() == null);
        sku.setDiscountable(Boolean.valueOf(true));
        assert (sku.isDiscountable().booleanValue());
        sku.setDiscountable(Boolean.valueOf(false));
        assert (!sku.isDiscountable().booleanValue());
        assert (sku.isAvailable() == null);
        sku.setAvailable(null);
        assert (sku.isAvailable() == null);
        sku.setAvailable(Boolean.valueOf(true));
        assert (sku.isAvailable().booleanValue());
        sku.setAvailable(Boolean.valueOf(false));
        assert (!sku.isAvailable().booleanValue());
        assert (sku.getName() == null);
    }
}

