/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.ProductDataProvider;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.CrossSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductWeight;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.UpSaleProductImpl;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.profile.util.WeightUnitOfMeasureType;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class ProductDaoTest
extends BaseTest {
    @Resource
    private ProductDao productDao;
    @Resource
    private CatalogService catalogService;

    @Test(groups={"createProducts"}, dataProvider="setupProducts", dataProviderClass=ProductDataProvider.class)
    @Rollback(value=false)
    public void createProducts(Product product) {
        product = this.catalogService.saveProduct(product);
        assert (product.getId() != null);
    }

    @Test(groups={"createUpSaleValues"}, dataProvider="basicUpSaleValue", dataProviderClass=ProductDataProvider.class, dependsOnGroups={"createProducts"})
    @Rollback(value=false)
    public void createUpSaleValues(Product product) {
        product = this.catalogService.saveProduct(product);
        assert (product.getId() != null);
    }

    @Test(groups={"testReadProductsWithUpSaleValues"}, dataProvider="basicUpSaleValue", dataProviderClass=ProductDataProvider.class, dependsOnGroups={"createUpSaleValues"})
    @Transactional
    public void testReadProductsWithUpSaleValues(Product product) {
        Product result = this.productDao.readProductById(product.getId());
        List related = result.getUpSaleProducts();
        assert (related != null);
        assert (!related.isEmpty());
        assert (related.size() == 2 || related.size() == 3);
        for (RelatedProduct rp : related) {
            assert (rp instanceof UpSaleProductImpl);
        }
    }

    @Test(groups={"createCrossSaleValues"}, dataProvider="basicCrossSaleValue", dataProviderClass=ProductDataProvider.class, dependsOnGroups={"testReadProductsWithUpSaleValues"})
    @Rollback(value=false)
    public void createCrossSaleValues(Product product) {
        product = this.catalogService.saveProduct(product);
        assert (product.getId() != null);
    }

    @Test(groups={"testReadProductsWithCrossSaleValues"}, dataProvider="basicCrossSaleValue", dataProviderClass=ProductDataProvider.class, dependsOnGroups={"createCrossSaleValues"})
    @Transactional
    public void testReadProductsWithCrossSaleValues(Product product) {
        Product result = this.productDao.readProductById(product.getId());
        List related = result.getCrossSaleProducts();
        assert (related != null);
        assert (!related.isEmpty());
        assert (related.size() == 2 || related.size() == 3);
        for (RelatedProduct rp : related) {
            assert (rp instanceof CrossSaleProductImpl);
        }
    }

    @Test(dataProvider="basicProduct", dataProviderClass=ProductDataProvider.class)
    public void testReadProductsById(Product product) {
        product = this.catalogService.saveProduct(product);
        Product result = this.productDao.readProductById(product.getId());
        assert (product.equals(result));
    }

    @Test(dataProvider="basicProduct", dataProviderClass=ProductDataProvider.class)
    @Transactional
    public void testReadProductsByName(Product product) {
        String name = product.getName();
        product = this.catalogService.saveProduct(product);
        List result = this.productDao.readProductsByName(name);
        assert (result.contains(product));
    }

    @Test(dataProvider="basicProduct", dataProviderClass=ProductDataProvider.class)
    public void testFeaturedProduct(Product product) {
        product = this.catalogService.saveProduct(product);
        Long productId = product.getId();
        product.setFeaturedProduct(true);
        this.catalogService.saveProduct(product);
        Product testProduct = this.productDao.readProductById(productId);
        assert (testProduct.isFeaturedProduct());
    }

    @Test(dataProvider="basicProduct", dataProviderClass=ProductDataProvider.class)
    public void testProductAttributes(Product product) {
        product.setWidth(new BigDecimal("25.5"));
        product.setHeight(new BigDecimal("50"));
        product.setDepth(new BigDecimal("75.5"));
        ProductWeight weight = new ProductWeight();
        weight.setWeightUnitOfMeasure(WeightUnitOfMeasureType.POUNDS);
        weight.setWeight(new BigDecimal("100.1"));
        product.setWeight(weight);
        product = this.catalogService.saveProduct(product);
        Product result = this.productDao.readProductById(product.getId());
        assert (result.getWidth().doubleValue() == 25.5);
        assert (result.getHeight().doubleValue() == 50.0);
        assert (result.getDepth().doubleValue() == 75.5);
        assert (result.getWeight().getWeight().doubleValue() == 100.1);
    }
}

