/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.CreditCardValidator;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.CreditCardType;
import org.broadleafcommerce.common.payment.PaymentAdditionalFieldType;
import org.broadleafcommerce.common.payment.PaymentGatewayRequestType;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.CreditCardDTO;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayTransactionService;
import org.broadleafcommerce.common.payment.service.FailureCountExposable;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.common.vendor.service.type.ServiceStatusType;
import org.broadleafcommerce.vendor.sample.service.payment.SamplePaymentGatewayType;
import org.springframework.stereotype.Service;

@Service(value="blSamplePaymentGatewayTransactionService")
public class SamplePaymentGatewayTransactionServiceImpl
extends AbstractPaymentGatewayTransactionService
implements FailureCountExposable {
    protected Integer failureCount = 0;
    protected Boolean isUp = true;

    public PaymentResponseDTO authorize(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        return this.commonCreditCardProcessing(paymentRequestDTO, PaymentTransactionType.AUTHORIZE);
    }

    public PaymentResponseDTO capture(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.CREDIT_CARD, SamplePaymentGatewayType.NULL_GATEWAY);
        responseDTO.valid(true).paymentTransactionType(PaymentTransactionType.CAPTURE).amount(new Money(paymentRequestDTO.getTransactionTotal())).rawResponse("Successful Capture").successful(true);
        return responseDTO;
    }

    public PaymentResponseDTO authorizeAndCapture(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        return this.commonCreditCardProcessing(paymentRequestDTO, PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
    }

    public PaymentResponseDTO reverseAuthorize(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.CREDIT_CARD, SamplePaymentGatewayType.NULL_GATEWAY);
        responseDTO.valid(true).paymentTransactionType(PaymentTransactionType.REVERSE_AUTH).amount(new Money(paymentRequestDTO.getTransactionTotal())).rawResponse("Successful Reverse Authorization").successful(true);
        return responseDTO;
    }

    public PaymentResponseDTO refund(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        if (paymentRequestDTO.getAdditionalFields().containsKey(PaymentGatewayRequestType.DETACHED_CREDIT_REFUND.getType())) {
            PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.CREDIT_CARD, SamplePaymentGatewayType.NULL_GATEWAY);
            responseDTO.valid(true).paymentTransactionType(PaymentTransactionType.DETACHED_CREDIT).amount(new Money(paymentRequestDTO.getTransactionTotal())).rawResponse("Successful Detached Credit").successful(true);
            return responseDTO;
        }
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.CREDIT_CARD, SamplePaymentGatewayType.NULL_GATEWAY);
        responseDTO.valid(true).paymentTransactionType(PaymentTransactionType.REFUND).amount(new Money(paymentRequestDTO.getTransactionTotal())).rawResponse("Successful Refund").successful(true);
        return responseDTO;
    }

    public PaymentResponseDTO voidPayment(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.CREDIT_CARD, SamplePaymentGatewayType.NULL_GATEWAY);
        responseDTO.valid(true).paymentTransactionType(PaymentTransactionType.VOID).amount(new Money(paymentRequestDTO.getTransactionTotal())).rawResponse("Successful Reverse Authorization").successful(true);
        return responseDTO;
    }

    protected PaymentResponseDTO commonCreditCardProcessing(PaymentRequestDTO requestDTO, PaymentTransactionType paymentTransactionType) {
        this.setupNoncePaymentRequest(requestDTO);
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.CREDIT_CARD, SamplePaymentGatewayType.NULL_GATEWAY);
        responseDTO.valid(true).paymentTransactionType(paymentTransactionType);
        CreditCardDTO creditCardDTO = requestDTO.getCreditCard();
        String transactionAmount = requestDTO.getTransactionTotal();
        String paymentToken = (String)requestDTO.getAdditionalFields().get(PaymentAdditionalFieldType.TOKEN.getType());
        CreditCardValidator visaValidator = new CreditCardValidator(2);
        CreditCardValidator amexValidator = new CreditCardValidator(1);
        CreditCardValidator mcValidator = new CreditCardValidator(4);
        CreditCardValidator discoverValidator = new CreditCardValidator(8);
        if (StringUtils.isNotBlank((CharSequence)transactionAmount) && StringUtils.isNotBlank((CharSequence)paymentToken)) {
            responseDTO.amount(new Money(requestDTO.getTransactionTotal())).rawResponse("Success!").successful(true);
        } else if (StringUtils.isNotBlank((CharSequence)transactionAmount) && creditCardDTO != null && StringUtils.isNotBlank((CharSequence)creditCardDTO.getCreditCardNum()) && (StringUtils.isNotBlank((CharSequence)creditCardDTO.getCreditCardExpDate()) || StringUtils.isNotBlank((CharSequence)creditCardDTO.getCreditCardExpMonth()) && StringUtils.isNotBlank((CharSequence)creditCardDTO.getCreditCardExpYear()))) {
            boolean validCard = false;
            if (visaValidator.isValid(creditCardDTO.getCreditCardNum())) {
                validCard = true;
            } else if (amexValidator.isValid(creditCardDTO.getCreditCardNum())) {
                validCard = true;
            } else if (mcValidator.isValid(creditCardDTO.getCreditCardNum())) {
                validCard = true;
            } else if (discoverValidator.isValid(creditCardDTO.getCreditCardNum())) {
                validCard = true;
            }
            boolean validDateFormat = false;
            boolean validDate = false;
            String[] parsedDate = null;
            parsedDate = StringUtils.isNotBlank((CharSequence)creditCardDTO.getCreditCardExpDate()) ? creditCardDTO.getCreditCardExpDate().split("/") : new String[]{creditCardDTO.getCreditCardExpMonth(), creditCardDTO.getCreditCardExpYear()};
            if (parsedDate.length == 2) {
                String expMonth = parsedDate[0];
                String expYear = parsedDate[1];
                ZoneId zone = ZoneId.systemDefault();
                try {
                    ZonedDateTime expirationDate = ZonedDateTime.of(Integer.parseInt("20" + expYear), Integer.parseInt(expMonth), 1, 0, 0, 0, 0, zone);
                    LocalDateTime expDate = expirationDate.toInstant().atZone(zone).toLocalDateTime();
                    validDate = expDate.isAfter(LocalDateTime.now());
                    validDateFormat = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!validDate || !validDateFormat) {
                responseDTO.amount(new Money(0)).rawResponse("cart.payment.expiration.invalid").successful(false);
            } else if (!validCard) {
                responseDTO.amount(new Money(0)).rawResponse("cart.payment.card.invalid").successful(false);
            } else {
                this.populateResponseDTO(responseDTO, requestDTO);
                responseDTO.amount(new Money(requestDTO.getTransactionTotal())).rawResponse("Success!").successful(true);
            }
        } else {
            responseDTO.amount(new Money(0)).rawResponse("cart.payment.invalid").successful(false);
        }
        return responseDTO;
    }

    protected void setupNoncePaymentRequest(PaymentRequestDTO requestDTO) {
        String nonce = (String)requestDTO.getAdditionalFields().get("PAYMENT_METHOD_NONCE");
        if (nonce != null) {
            String[] fields = nonce.split("#");
            String lastFour = fields[0] == null ? null : fields[0].substring(fields[0].length() - 4);
            requestDTO.creditCard().creditCardType(CreditCardType.MASTERCARD.getType()).creditCardNum(fields[0]).creditCardLastFour(lastFour).creditCardHolderName(fields[1]).creditCardExpDate(fields[2]).creditCardCvv(fields[3]);
        }
    }

    protected void populateResponseDTO(PaymentResponseDTO responseDTO, PaymentRequestDTO requestDTO) {
        HashMap<String, String> additionalResponseItems = new HashMap<String, String>();
        CreditCardDTO creditCardDTO = requestDTO.getCreditCard();
        additionalResponseItems.put(PaymentAdditionalFieldType.CARD_TYPE.getType(), creditCardDTO.getCreditCardType());
        additionalResponseItems.put(PaymentAdditionalFieldType.NAME_ON_CARD.getType(), creditCardDTO.getCreditCardHolderName());
        additionalResponseItems.put(PaymentAdditionalFieldType.LAST_FOUR.getType(), creditCardDTO.getCreditCardLastFour());
        additionalResponseItems.put(PaymentAdditionalFieldType.EXP_DATE.getType(), creditCardDTO.getCreditCardExpDate());
        responseDTO.getResponseMap().putAll(additionalResponseItems);
    }

    public ServiceStatusType getServiceStatus() {
        if (this.isUp.booleanValue()) {
            return ServiceStatusType.UP;
        }
        return ServiceStatusType.DOWN;
    }

    public synchronized void clearStatus() {
        this.isUp = true;
        this.failureCount = 0;
    }

    public synchronized void incrementFailure() {
        if (this.failureCount >= this.getFailureReportingThreshold()) {
            this.isUp = false;
        } else {
            Integer n = this.failureCount;
            this.failureCount = this.failureCount + 1;
        }
    }

    public Integer getFailureReportingThreshold() {
        return 3;
    }
}

