/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.util.Random;
import org.broadleafcommerce.common.payment.CreditCardType;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.GatewayCustomerDTO;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayCustomerService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.vendor.sample.service.payment.SamplePaymentGatewayType;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="blSamplePaymentGatewayCustomerService")
public class SamplePaymentGatewayCustomerServiceImpl
extends AbstractPaymentGatewayCustomerService {
    public static final String RESPONSE_MAP_KEY_PREFEIX = "customer";

    public PaymentResponseDTO createGatewayCustomer(PaymentRequestDTO requestDTO) throws PaymentException {
        Assert.isTrue((boolean)requestDTO.customerPopulated(), (String)"The Gateway Customer information on the Payment Request DTO must not be null and must be populated");
        return this.buildSampleGatewayResponse(requestDTO, org.broadleafcommerce.vendor.sample.service.payment.PaymentTransactionType.CREATE_CUSTOMER);
    }

    public PaymentResponseDTO updateGatewayCustomer(PaymentRequestDTO requestDTO) throws PaymentException {
        Assert.isTrue((requestDTO.customerPopulated() && requestDTO.getCustomer().getCustomerId() != null ? 1 : 0) != 0, (String)"The Gateway Customer information on the Payment Request DTO must not be null and must be populated");
        return this.buildSampleGatewayResponse(requestDTO, org.broadleafcommerce.vendor.sample.service.payment.PaymentTransactionType.UPDATE_CUSTOMER);
    }

    public PaymentResponseDTO deleteGatewayCustomer(PaymentRequestDTO requestDTO) throws PaymentException {
        Assert.isTrue((requestDTO.getCustomer() != null && requestDTO.getCustomer().getCustomerId() != null ? 1 : 0) != 0, (String)"The Gateway Customer Customer ID on the Payment Request DTO must not be null and must be populated");
        return this.buildSampleGatewayResponse(requestDTO, org.broadleafcommerce.vendor.sample.service.payment.PaymentTransactionType.DELETE_CUSTOMER);
    }

    protected PaymentResponseDTO buildSampleGatewayResponse(PaymentRequestDTO requestDTO, org.broadleafcommerce.vendor.sample.service.payment.PaymentTransactionType transactionType) {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.CREDIT_CARD, SamplePaymentGatewayType.NULL_GATEWAY).paymentTransactionType((PaymentTransactionType)transactionType).successful(true);
        this.parseCustomer(responseDTO, requestDTO);
        this.parseCreditCard(responseDTO, requestDTO);
        this.parsePaymentToken(responseDTO);
        return responseDTO;
    }

    protected void parseCustomer(PaymentResponseDTO responseDTO, PaymentRequestDTO requestDTO) {
        GatewayCustomerDTO customer = requestDTO.getCustomer();
        responseDTO.customer().customerId(customer.getCustomerId());
        responseDTO.responseMap("customer.id", customer.getCustomerId()).responseMap("customer.firstName", customer.getFirstName()).responseMap("customer.lastName", customer.getLastName()).responseMap("customer.emailAddress", customer.getEmail()).responseMap("customer.phoneNumber", customer.getPhone()).responseMap("customer.company", customer.getCompanyName()).responseMap("customer.website", customer.getWebsite());
    }

    protected void parseCreditCard(PaymentResponseDTO responseDTO, PaymentRequestDTO requestDTO) {
        GatewayCustomerDTO customer = requestDTO.getCustomer();
        responseDTO.creditCard().creditCardHolderName(customer.getFirstName() + " " + customer.getLastName()).creditCardLastFour("1111").creditCardType(CreditCardType.MASTERCARD.getType()).creditCardExpDate("01/99");
    }

    protected void parsePaymentToken(PaymentResponseDTO responseDTO) {
        Random rnd = new Random();
        int randomNumber = 100000 + rnd.nextInt(90000000);
        responseDTO.paymentToken("SAMPLE_PAYMENT_GATEWAY_MULTI_USE_TOKEN_" + randomNumber);
    }
}

