/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayConfiguration;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.payment.service.gateway.SamplePaymentGatewayConfiguration;
import org.broadleafcommerce.vendor.sample.service.payment.SamplePaymentGatewayType;
import org.springframework.stereotype.Service;

@Service(value="blSamplePaymentGatewayConfiguration")
public class SamplePaymentGatewayConfigurationImpl
extends AbstractPaymentGatewayConfiguration
implements SamplePaymentGatewayConfiguration {
    protected int failureReportingThreshold = 1;
    protected boolean performAuthorizeAndCapture = false;

    @Override
    public String getTransparentRedirectUrl() {
        return BroadleafRequestContext.getBroadleafRequestContext().getWebRequest().getContextPath() + "/sample-checkout/process";
    }

    @Override
    public String getTransparentRedirectReturnUrl() {
        return BroadleafRequestContext.getBroadleafRequestContext().getWebRequest().getContextPath() + "/sample-checkout/return";
    }

    @Override
    public String getCustomerPaymentTransparentRedirectUrl() {
        return BroadleafRequestContext.getBroadleafRequestContext().getWebRequest().getContextPath() + "/sample-customer-payment/process";
    }

    @Override
    public String getCustomerPaymentTransparentRedirectReturnUrl() {
        return BroadleafRequestContext.getBroadleafRequestContext().getWebRequest().getContextPath() + "/sample-customer-payment/return";
    }

    public boolean isPerformAuthorizeAndCapture() {
        return true;
    }

    public void setPerformAuthorizeAndCapture(boolean performAuthorizeAndCapture) {
        this.performAuthorizeAndCapture = performAuthorizeAndCapture;
    }

    public int getFailureReportingThreshold() {
        return this.failureReportingThreshold;
    }

    public void setFailureReportingThreshold(int failureReportingThreshold) {
        this.failureReportingThreshold = failureReportingThreshold;
    }

    public boolean handlesAuthorize() {
        return true;
    }

    public boolean handlesCapture() {
        return false;
    }

    public boolean handlesAuthorizeAndCapture() {
        return true;
    }

    public boolean handlesReverseAuthorize() {
        return false;
    }

    public boolean handlesVoid() {
        return false;
    }

    public boolean handlesRefund() {
        return false;
    }

    public boolean handlesPartialCapture() {
        return false;
    }

    public boolean handlesMultipleShipment() {
        return false;
    }

    public boolean handlesRecurringPayment() {
        return false;
    }

    public boolean handlesSavedCustomerPayment() {
        return false;
    }

    public boolean handlesMultiplePayments() {
        return false;
    }

    public PaymentGatewayType getGatewayType() {
        return SamplePaymentGatewayType.NULL_GATEWAY;
    }
}

