/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.admin.domain.AdminMainEntity;
import org.broadleafcommerce.common.audit.Auditable;
import org.broadleafcommerce.common.audit.AuditableListener;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCloneable;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.domain.LocaleImpl;
import org.broadleafcommerce.common.persistence.PreviewStatus;
import org.broadleafcommerce.common.persistence.Previewable;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationMap;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.AddMethodType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.profile.core.domain.ChallengeQuestion;
import org.broadleafcommerce.profile.core.domain.ChallengeQuestionImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.CustomerAddressImpl;
import org.broadleafcommerce.profile.core.domain.CustomerAttribute;
import org.broadleafcommerce.profile.core.domain.CustomerAttributeImpl;
import org.broadleafcommerce.profile.core.domain.CustomerPayment;
import org.broadleafcommerce.profile.core.domain.CustomerPaymentImpl;
import org.broadleafcommerce.profile.core.domain.CustomerPersistedEntityListener;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.broadleafcommerce.profile.core.domain.CustomerPhoneImpl;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Where;

@Entity
@EntityListeners(value={AuditableListener.class, CustomerPersistedEntityListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CUSTOMER")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blCustomerElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="CustomerImpl_baseCustomer")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"preview"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantSite"})})
public class CustomerImpl
implements Customer,
AdminMainEntity,
Previewable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="CUSTOMER_ID")
    @AdminPresentation(friendlyName="CustomerImpl_Customer_Id", group="CustomerImpl_Primary_Key", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Embedded
    protected Auditable auditable = new Auditable();
    @Embedded
    protected PreviewStatus previewable = new PreviewStatus();
    @Column(name="USER_NAME")
    @AdminPresentation(friendlyName="CustomerImpl_UserName", order=4000, group="CustomerImpl_Customer")
    protected String username;
    @Column(name="PASSWORD")
    @AdminPresentation(excluded=true)
    protected String password;
    @Column(name="EMAIL_ADDRESS")
    @Index(name="CUSTOMER_EMAIL_INDEX", columnNames={"EMAIL_ADDRESS"})
    @AdminPresentation(friendlyName="CustomerImpl_Email_Address", order=1000, group="CustomerImpl_Customer", prominent=true, gridOrder=1000)
    protected String emailAddress;
    @Column(name="FIRST_NAME")
    @AdminPresentation(friendlyName="CustomerImpl_First_Name", order=2000, group="CustomerImpl_Customer", prominent=true, gridOrder=2000)
    protected String firstName;
    @Column(name="LAST_NAME")
    @AdminPresentation(friendlyName="CustomerImpl_Last_Name", order=3000, group="CustomerImpl_Customer", prominent=true, gridOrder=3000)
    protected String lastName;
    @ManyToOne(targetEntity=ChallengeQuestionImpl.class)
    @JoinColumn(name="CHALLENGE_QUESTION_ID")
    @Index(name="CUSTOMER_CHALLENGE_INDEX", columnNames={"CHALLENGE_QUESTION_ID"})
    @AdminPresentation(friendlyName="CustomerImpl_Challenge_Question", order=4000, tab="CustomerImpl_Advanced_Tab", tabOrder=3000, excluded=true)
    protected ChallengeQuestion challengeQuestion;
    @Column(name="CHALLENGE_ANSWER")
    @AdminPresentation(friendlyName="CustomerImpl_Challenge_Answer", order=5000, tab="CustomerImpl_Advanced_Tab", tabOrder=3000, excluded=true)
    protected String challengeAnswer;
    @Column(name="PASSWORD_CHANGE_REQUIRED")
    @AdminPresentation(excluded=true)
    protected Boolean passwordChangeRequired = false;
    @Column(name="RECEIVE_EMAIL")
    @AdminPresentation(friendlyName="CustomerImpl_Customer_Receive_Email", order=1000, tab="CustomerImpl_Advanced_Tab", tabOrder=3000)
    protected Boolean receiveEmail = true;
    @Column(name="IS_REGISTERED")
    @AdminPresentation(friendlyName="CustomerImpl_Customer_Registered", order=4000, prominent=true, gridOrder=4000)
    protected Boolean registered = false;
    @Column(name="DEACTIVATED")
    @AdminPresentation(friendlyName="CustomerImpl_Customer_Deactivated", order=3000, tab="CustomerImpl_Advanced_Tab", tabOrder=3000)
    protected Boolean deactivated = false;
    @ManyToOne(targetEntity=LocaleImpl.class)
    @JoinColumn(name="LOCALE_CODE")
    @AdminPresentation(friendlyName="CustomerImpl_Customer_Locale", order=4000, tab="CustomerImpl_Advanced_Tab", tabOrder=3000, excluded=true, visibility=VisibilityEnum.GRID_HIDDEN)
    protected Locale customerLocale;
    @OneToMany(mappedBy="customer", targetEntity=CustomerAttributeImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blStandardElements")
    @MapKey(name="name")
    @BatchSize(size=50)
    @AdminPresentationMap(friendlyName="CustomerAttributeImpl_Attribute_Name", deleteEntityUponRemove=true, forceFreeFormKeys=true, keyPropertyFriendlyName="ProductAttributeImpl_Attribute_Name", tab="CustomerImpl_Advanced_Tab", tabOrder=3000)
    protected Map<String, CustomerAttribute> customerAttributes = new HashMap<String, CustomerAttribute>();
    @OneToMany(mappedBy="customer", targetEntity=CustomerAddressImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @Where(clause="archived != 'Y'")
    @AdminPresentationCollection(friendlyName="CustomerImpl_Customer_Addresses", order=1000, addType=AddMethodType.PERSIST, tab="CustomerImpl_Contact_Tab", tabOrder=2000)
    protected List<CustomerAddress> customerAddresses = new ArrayList<CustomerAddress>();
    @OneToMany(mappedBy="customer", targetEntity=CustomerPhoneImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @AdminPresentationCollection(friendlyName="CustomerImpl_Customer_Phones", order=2000, addType=AddMethodType.PERSIST, tab="CustomerImpl_Contact_Tab", tabOrder=2000)
    protected List<CustomerPhone> customerPhones = new ArrayList<CustomerPhone>();
    @OneToMany(mappedBy="customer", targetEntity=CustomerPaymentImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    @AdminPresentationCollection(friendlyName="CustomerImpl_Customer_Payments", order=3000, addType=AddMethodType.PERSIST, readOnly=true, tab="CustomerImpl_Contact_Tab", tabOrder=2000)
    protected List<CustomerPayment> customerPayments = new ArrayList<CustomerPayment>();
    @Column(name="TAX_EXEMPTION_CODE")
    @AdminPresentation(friendlyName="CustomerImpl_Customer_TaxExemptCode", order=5000, tab="CustomerImpl_Advanced_Tab", tabOrder=3000, visibility=VisibilityEnum.GRID_HIDDEN)
    protected String taxExemptionCode;
    @Transient
    protected String unencodedPassword;
    @Transient
    protected String unencodedChallengeAnswer;
    @Transient
    protected boolean anonymous;
    @Transient
    protected boolean cookied;
    @Transient
    protected boolean loggedIn;
    @Transient
    protected Map<String, Object> transientProperties = new HashMap<String, Object>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isPasswordChangeRequired() {
        return BooleanUtils.toBoolean((Boolean)this.passwordChangeRequired);
    }

    @Override
    public void setPasswordChangeRequired(boolean passwordChangeRequired) {
        this.passwordChangeRequired = passwordChangeRequired;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public ChallengeQuestion getChallengeQuestion() {
        return this.challengeQuestion;
    }

    @Override
    public void setChallengeQuestion(ChallengeQuestion challengeQuestion) {
        this.challengeQuestion = challengeQuestion;
    }

    @Override
    public String getChallengeAnswer() {
        return this.challengeAnswer;
    }

    @Override
    public void setChallengeAnswer(String challengeAnswer) {
        this.challengeAnswer = challengeAnswer;
    }

    @Override
    public String getUnencodedPassword() {
        return this.unencodedPassword;
    }

    @Override
    public void setUnencodedPassword(String unencodedPassword) {
        this.unencodedPassword = unencodedPassword;
    }

    @Override
    public boolean isReceiveEmail() {
        return BooleanUtils.toBoolean((Boolean)this.receiveEmail);
    }

    @Override
    public void setReceiveEmail(boolean receiveEmail) {
        this.receiveEmail = receiveEmail;
    }

    @Override
    public boolean isRegistered() {
        return BooleanUtils.toBoolean((Boolean)this.registered);
    }

    @Override
    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    @Override
    public String getUnencodedChallengeAnswer() {
        return this.unencodedChallengeAnswer;
    }

    @Override
    public void setUnencodedChallengeAnswer(String unencodedChallengeAnswer) {
        this.unencodedChallengeAnswer = unencodedChallengeAnswer;
    }

    @Override
    public Auditable getAuditable() {
        return this.auditable;
    }

    @Override
    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public boolean isCookied() {
        return this.cookied;
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
        if (anonymous) {
            this.cookied = false;
            this.loggedIn = false;
        }
    }

    @Override
    public void setCookied(boolean cookied) {
        this.cookied = cookied;
        if (cookied) {
            this.anonymous = false;
            this.loggedIn = false;
        }
    }

    @Override
    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
        if (loggedIn) {
            this.anonymous = false;
            this.cookied = false;
        }
    }

    @Override
    public Locale getCustomerLocale() {
        return this.customerLocale;
    }

    @Override
    public void setCustomerLocale(Locale customerLocale) {
        this.customerLocale = customerLocale;
    }

    @Override
    public Map<String, CustomerAttribute> getCustomerAttributes() {
        return this.customerAttributes;
    }

    @Override
    public void setCustomerAttributes(Map<String, CustomerAttribute> customerAttributes) {
        this.customerAttributes = customerAttributes;
    }

    @Override
    public boolean isDeactivated() {
        return BooleanUtils.toBoolean((Boolean)this.deactivated);
    }

    @Override
    public void setDeactivated(boolean deactivated) {
        this.deactivated = deactivated;
    }

    @Override
    public List<CustomerAddress> getCustomerAddresses() {
        return this.customerAddresses;
    }

    @Override
    public void setCustomerAddresses(List<CustomerAddress> customerAddresses) {
        this.customerAddresses = customerAddresses;
    }

    @Override
    public List<CustomerPhone> getCustomerPhones() {
        return this.customerPhones;
    }

    @Override
    public void setCustomerPhones(List<CustomerPhone> customerPhones) {
        this.customerPhones = customerPhones;
    }

    @Override
    public List<CustomerPayment> getCustomerPayments() {
        return this.customerPayments;
    }

    @Override
    public void setCustomerPayments(List<CustomerPayment> customerPayments) {
        this.customerPayments = customerPayments;
    }

    public String getMainEntityName() {
        if (!StringUtils.isEmpty((CharSequence)this.getFirstName()) && !StringUtils.isEmpty((CharSequence)this.getLastName())) {
            return this.getFirstName() + " " + this.getLastName();
        }
        return String.valueOf(this.getId());
    }

    public Boolean getPreview() {
        if (this.previewable == null) {
            this.previewable = new PreviewStatus();
        }
        return this.previewable.getPreview();
    }

    public void setPreview(Boolean preview) {
        if (this.previewable == null) {
            this.previewable = new PreviewStatus();
        }
        this.previewable.setPreview(preview);
    }

    @Override
    public Map<String, Object> getTransientProperties() {
        return this.transientProperties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        CustomerImpl other = (CustomerImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public <G extends Customer> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        MultiTenantCloneable<CustomerAddress> clonedEntry;
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        Customer cloned = (Customer)createResponse.getClone();
        cloned.setAnonymous(this.anonymous);
        cloned.setChallengeAnswer(this.challengeAnswer);
        cloned.setChallengeQuestion(this.challengeQuestion);
        cloned.setCookied(this.cookied);
        for (CustomerAddress customerAddress : this.customerAddresses) {
            clonedEntry = (CustomerAddress)customerAddress.createOrRetrieveCopyInstance(context).getClone();
            clonedEntry.setCustomer(cloned);
            cloned.getCustomerAddresses().add((CustomerAddress)clonedEntry);
        }
        for (Map.Entry entry : this.customerAttributes.entrySet()) {
            clonedEntry = (CustomerAttribute)((CustomerAttribute)entry.getValue()).createOrRetrieveCopyInstance(context).getClone();
            clonedEntry.setCustomer(cloned);
            cloned.getCustomerAttributes().put((String)entry.getKey(), (CustomerAttribute)clonedEntry);
        }
        cloned.setLoggedIn(this.loggedIn);
        cloned.setUsername(this.username);
        cloned.setUnencodedPassword(this.unencodedPassword);
        cloned.setTaxExemptionCode(this.taxExemptionCode);
        cloned.setUnencodedChallengeAnswer(this.unencodedChallengeAnswer);
        cloned.setRegistered(this.registered);
        cloned.setReceiveEmail(this.receiveEmail);
        cloned.setPasswordChangeRequired(this.passwordChangeRequired);
        cloned.setPassword(this.password);
        cloned.setLastName(this.lastName);
        cloned.setFirstName(this.firstName);
        cloned.setEmailAddress(this.emailAddress);
        cloned.setDeactivated(this.deactivated);
        for (CustomerPayment customerPayment : this.customerPayments) {
            clonedEntry = (CustomerPayment)customerPayment.createOrRetrieveCopyInstance(context).getClone();
            clonedEntry.setCustomer(cloned);
            cloned.getCustomerPayments().add((CustomerPayment)clonedEntry);
        }
        for (CustomerPhone customerPhone : this.customerPhones) {
            clonedEntry = (CustomerPhone)customerPhone.createOrRetrieveCopyInstance(context).getClone();
            clonedEntry.setCustomer(cloned);
            cloned.getCustomerPhones().add((CustomerPhone)clonedEntry);
        }
        return createResponse;
    }

    @Override
    public String getTaxExemptionCode() {
        return this.taxExemptionCode;
    }

    @Override
    public void setTaxExemptionCode(String exemption) {
        this.taxExemptionCode = exemption;
    }

    @Override
    public boolean isTaxExempt() {
        return StringUtils.isNotEmpty((CharSequence)this.taxExemptionCode);
    }

    public static class Presentation {

        public static class Tab {

            public static class Order {
                public static final int Contact = 2000;
                public static final int Advanced = 3000;
            }

            public static class Name {
                public static final String Contact = "CustomerImpl_Contact_Tab";
                public static final String Advanced = "CustomerImpl_Advanced_Tab";
            }
        }
    }
}

